/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class AbstractData<T>
implements IBindableData<T> {
    protected final Supplier<T> _getter;
    @Nullable
    private final IEvent<Consumer<T>> _bindings;

    protected static <T> AbstractData<T> of(final T defaultValue) {
        return new AbstractData<T>(){

            @Override
            public T defaultValue() {
                return defaultValue;
            }
        };
    }

    protected static <O> IBindableData<O> as(final @Nullable O defaultValue, final Consumer<Consumer<O>> binding) {
        Preconditions.checkNotNull(binding, (Object)"Binding must not be null.");
        return new IBindableData<O>(){

            @Override
            public void bind(@Nonnull Consumer<O> consumer) {
                Preconditions.checkNotNull(consumer, (Object)"Consumer must not be null.");
                binding.accept(consumer);
            }

            @Override
            @Nullable
            public O defaultValue() {
                return defaultValue;
            }
        };
    }

    protected AbstractData() {
        this._bindings = new Event<Consumer<T>>();
        this._getter = () -> {
            throw new IllegalStateException("Getter called on the client side");
        };
    }

    protected AbstractData(NonNullSupplier<Supplier<T>> serverSideGetter) {
        this._bindings = null;
        this._getter = Objects.requireNonNull((Supplier)serverSideGetter.get());
    }

    public void notify(@Nullable T value) {
        assert (null != this._bindings);
        this._bindings.raise(c -> c.accept(value));
    }

    @Override
    public void bind(Consumer<T> consumer) {
        Preconditions.checkNotNull(consumer, (Object)"Consumer must not be null.");
        Preconditions.checkState((null != this._bindings ? 1 : 0) != 0, (Object)"bind() called on the server logical side.");
        this._bindings.subscribe(consumer);
    }
}

