/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;

public class EnumData<T extends Enum<T>>
extends AbstractData<T>
implements IContainerData {
    private final Class<T> _enumClass;
    private T _lastValue;

    public static <T extends Enum<T>> EnumData<T> immutable(ModContainer container, boolean isClientSide, Class<T> enumClass, T value) {
        return EnumData.of(container, isClientSide, enumClass, () -> () -> value);
    }

    public static <T extends Enum<T>> EnumData<T> sampled(int frequency, ModContainer container, boolean isClientSide, Class<T> enumClass, NonNullSupplier<Supplier<T>> serverSideGetter) {
        return EnumData.of(container, isClientSide, enumClass, () -> new Sampler(frequency, serverSideGetter));
    }

    public static <T extends Enum<T>> EnumData<T> of(ModContainer container, boolean isClientSide, Class<T> enumClass, NonNullSupplier<Supplier<T>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        EnumData<T> data = isClientSide ? new EnumData<T>(enumClass) : new EnumData<T>(enumClass, serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        Enum current = (Enum)this._getter.get();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.m_130130_(null != current ? current.ordinal() : -1);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        int ordinal = dataSource.m_130242_();
        Enum data = -1 == ordinal ? null : ((Enum[])this._enumClass.getEnumConstants())[ordinal];
        this.notify(data);
    }

    @Override
    @Nullable
    public T defaultValue() {
        return (T)((Enum[])this._enumClass.getEnumConstants())[0];
    }

    private EnumData(Class<T> enumClass) {
        this._enumClass = enumClass;
    }

    private EnumData(Class<T> enumClass, NonNullSupplier<Supplier<T>> serverSideGetter) {
        super(serverSideGetter);
        this._enumClass = enumClass;
        this._lastValue = null;
    }
}

