/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;

public class FloatData
extends AbstractData<Float>
implements IContainerData {
    private float _lastValue;

    public static FloatData immutable(ModContainer container, boolean isClientSide, float value) {
        return FloatData.of(container, isClientSide, (NonNullSupplier<Supplier<Float>>)((NonNullSupplier)() -> () -> Float.valueOf(value)));
    }

    public static FloatData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Float>> serverSideGetter) {
        return FloatData.of(container, isClientSide, (NonNullSupplier<Supplier<Float>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static FloatData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Float>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        FloatData data = isClientSide ? new FloatData() : new FloatData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static FloatData of(ModContainer container, boolean isClientSide, float[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        FloatData data = FloatData.of(container, isClientSide, (NonNullSupplier<Supplier<Float>>)((NonNullSupplier)() -> () -> Float.valueOf(array[index])));
        if (isClientSide) {
            data.bind(v -> {
                array[index] = v.floatValue();
            });
        }
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        float current = ((Float)this._getter.get()).floatValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeFloat(current);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(Float.valueOf(dataSource.readFloat()));
    }

    @Override
    @Nullable
    public Float defaultValue() {
        return Float.valueOf(0.0f);
    }

    private FloatData() {
    }

    private FloatData(NonNullSupplier<Supplier<Float>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = 0.0f;
    }
}

