/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.fluid.FluidStackHolder;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackData
extends AbstractData<FluidStack>
implements IContainerData {
    private FluidStack _lastValue;
    private AbstractData<Integer> _amountData;

    public static FluidStackData immutable(ModContainer container, boolean isClientSide, FluidStack value) {
        return FluidStackData.of(container, isClientSide, (NonNullSupplier<Supplier<FluidStack>>)((NonNullSupplier)() -> () -> value));
    }

    public static FluidStackData empty(boolean isClientSide) {
        return isClientSide ? new FluidStackData() : new FluidStackData((NonNullSupplier<Supplier<FluidStack>>)((NonNullSupplier)() -> () -> FluidStack.EMPTY));
    }

    public static FluidStackData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<FluidStack>> serverSideGetter) {
        return FluidStackData.of(container, isClientSide, (NonNullSupplier<Supplier<FluidStack>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static FluidStackData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<FluidStack>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        FluidStackData data = isClientSide ? new FluidStackData() : new FluidStackData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static FluidStackData of(ModContainer container, boolean isClientSide, NonNullList<FluidStack> list, int index) {
        Preconditions.checkNotNull(list, (Object)"List must not be null.");
        Preconditions.checkArgument((index >= 0 && index < list.size() ? 1 : 0) != 0, (Object)"Index must be a valid index for the list.");
        FluidStackData data = FluidStackData.of(container, isClientSide, (NonNullSupplier<Supplier<FluidStack>>)((NonNullSupplier)() -> () -> (FluidStack)list.get(index)));
        if (isClientSide) {
            data.bind(v -> list.set(index, v));
        }
        return data;
    }

    public static FluidStackData of(ModContainer container, boolean isClientSide, IStackHolderAccess<FluidStackHolder, FluidStack> holder, int index) {
        Preconditions.checkNotNull(holder, (Object)"Holder must not be null.");
        FluidStackData data = FluidStackData.of(container, isClientSide, (NonNullSupplier<Supplier<FluidStack>>)((NonNullSupplier)() -> () -> (FluidStack)holder.getStackAt(index)));
        if (isClientSide) {
            data.bind(v -> holder.setStackAt(index, (FluidStack)v));
        }
        return data;
    }

    public IBindableData<Integer> amount() {
        if (null == this._amountData) {
            this._amountData = AbstractData.of(0);
        }
        return this._amountData;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        FluidStack current = (FluidStack)this._getter.get();
        if (this._lastValue.isEmpty() && current.isEmpty()) {
            return null;
        }
        boolean equalFluid = current.isFluidEqual(this._lastValue);
        if (!equalFluid || current.getAmount() != this._lastValue.getAmount()) {
            this._lastValue = current.copy();
            if (equalFluid) {
                return buffer -> {
                    buffer.writeByte(1);
                    buffer.m_130130_(current.getAmount());
                };
            }
            return buffer -> {
                buffer.writeByte(0);
                buffer.writeFluidStack(current);
            };
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        switch (dataSource.readByte()) {
            case 0: {
                FluidStack data = dataSource.readFluidStack();
                this.notify(data);
                if (null == this._amountData) break;
                this._amountData.notify(data.getAmount());
                break;
            }
            case 1: {
                if (null == this._amountData) break;
                this._amountData.notify(dataSource.m_130242_());
            }
        }
    }

    @Override
    public FluidStack defaultValue() {
        return FluidStack.EMPTY;
    }

    private FluidStackData() {
    }

    private FluidStackData(NonNullSupplier<Supplier<FluidStack>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = FluidStack.EMPTY;
    }
}

