/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;

public class IntData
extends AbstractData<Integer>
implements IContainerData {
    private int _lastValue;

    public static IntData immutable(ModContainer container, boolean isClientSide, int value) {
        return IntData.of(container, isClientSide, (NonNullSupplier<Supplier<Integer>>)((NonNullSupplier)() -> () -> value));
    }

    public static IntData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Integer>> serverSideGetter) {
        return IntData.of(container, isClientSide, (NonNullSupplier<Supplier<Integer>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static IntData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Integer>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        IntData data = isClientSide ? new IntData() : new IntData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static IntData of(ModContainer container, boolean isClientSide, int[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        IntData data = IntData.of(container, isClientSide, (NonNullSupplier<Supplier<Integer>>)((NonNullSupplier)() -> () -> array[index]));
        if (isClientSide) {
            data.bind(v -> {
                array[index] = v;
            });
        }
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        int current = (Integer)this._getter.get();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.m_130130_(current);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(dataSource.m_130242_());
    }

    @Override
    @Nullable
    public Integer defaultValue() {
        return 0;
    }

    private IntData() {
    }

    private IntData(NonNullSupplier<Supplier<Integer>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = 0;
    }
}

