/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemStackData
extends AbstractData<ItemStack>
implements IContainerData {
    private ItemStack _lastValue;
    private AbstractData<Integer> _amountData;

    public static ItemStackData immutable(ModContainer container, boolean isClientSide, ItemStack value) {
        return ItemStackData.of(container, isClientSide, (NonNullSupplier<Supplier<ItemStack>>)((NonNullSupplier)() -> () -> value));
    }

    public static ItemStackData empty(boolean isClientSide) {
        return isClientSide ? new ItemStackData() : new ItemStackData((NonNullSupplier<Supplier<ItemStack>>)((NonNullSupplier)() -> () -> ItemStack.f_41583_));
    }

    public static ItemStackData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<ItemStack>> serverSideGetter) {
        return ItemStackData.of(container, isClientSide, (NonNullSupplier<Supplier<ItemStack>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static ItemStackData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<ItemStack>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        ItemStackData data = isClientSide ? new ItemStackData() : new ItemStackData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static ItemStackData of(ModContainer container, boolean isClientSide, NonNullList<ItemStack> list, int index) {
        Preconditions.checkNotNull(list, (Object)"List must not be null.");
        Preconditions.checkArgument((index >= 0 && index < list.size() ? 1 : 0) != 0, (Object)"Index must be a valid index for the list.");
        ItemStackData data = ItemStackData.of(container, isClientSide, (NonNullSupplier<Supplier<ItemStack>>)((NonNullSupplier)() -> () -> (ItemStack)list.get(index)));
        if (isClientSide) {
            data.bind(v -> list.set(index, v));
        }
        return data;
    }

    public static ItemStackData of(ModContainer container, boolean isClientSide, IItemHandlerModifiable handler, int slot) {
        Preconditions.checkNotNull((Object)handler, (Object)"Handler must not be null.");
        Preconditions.checkArgument((slot >= 0 && slot < handler.getSlots() ? 1 : 0) != 0, (Object)"Slot must be a valid slot index for the handler.");
        ItemStackData data = ItemStackData.of(container, isClientSide, (NonNullSupplier<Supplier<ItemStack>>)((NonNullSupplier)() -> () -> handler.getStackInSlot(slot)));
        if (isClientSide) {
            data.bind(v -> handler.setStackInSlot(slot, v));
        }
        return data;
    }

    public static ItemStackData of(ModContainer container, boolean isClientSide, IStackHolderAccess<ItemStackHolder, ItemStack> holder, int index) {
        Preconditions.checkNotNull(holder, (Object)"Holder must not be null.");
        ItemStackData data = ItemStackData.of(container, isClientSide, (NonNullSupplier<Supplier<ItemStack>>)((NonNullSupplier)() -> () -> (ItemStack)holder.getStackAt(index)));
        if (isClientSide) {
            data.bind(v -> holder.setStackAt(index, (ItemStack)v));
        }
        return data;
    }

    public IBindableData<Integer> amount() {
        if (null == this._amountData) {
            this._amountData = AbstractData.of(0);
        }
        return this._amountData;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        ItemStack current = (ItemStack)this._getter.get();
        if (this._lastValue.m_41619_() && current.m_41619_()) {
            return null;
        }
        boolean equalItem = ItemHelper.stackMatch(this._lastValue, current, ItemHelper.MatchOption.MATCH_ITEM_DAMAGE_NBT);
        if (!equalItem || current.m_41613_() != this._lastValue.m_41613_()) {
            this._lastValue = current.m_41777_();
            if (equalItem) {
                return buffer -> {
                    buffer.writeByte(1);
                    buffer.m_130130_(current.m_41613_());
                };
            }
            return buffer -> {
                buffer.writeByte(0);
                buffer.writeItemStack(current, true);
            };
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        switch (dataSource.readByte()) {
            case 0: {
                ItemStack data = dataSource.m_130267_();
                this.notify(data);
                if (null == this._amountData) break;
                this._amountData.notify(data.m_41613_());
                break;
            }
            case 1: {
                if (null == this._amountData) break;
                this._amountData.notify(dataSource.m_130242_());
            }
        }
    }

    @Override
    @Nullable
    public ItemStack defaultValue() {
        return ItemStack.f_41583_;
    }

    private ItemStackData() {
    }

    private ItemStackData(NonNullSupplier<Supplier<ItemStack>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = ItemStack.f_41583_;
    }
}

