/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;

public class WideAmountData
extends AbstractData<WideAmount>
implements IContainerData {
    private WideAmount _lastValue;
    @Nullable
    private IBindableData<Double> _asDoubleBindable;

    public static WideAmountData immutable(ModContainer container, boolean isClientSide, WideAmount value) {
        return WideAmountData.of(container, isClientSide, (NonNullSupplier<Supplier<WideAmount>>)((NonNullSupplier)() -> () -> value));
    }

    public static WideAmountData empty(boolean isClientSide) {
        return isClientSide ? new WideAmountData() : new WideAmountData((NonNullSupplier<Supplier<WideAmount>>)((NonNullSupplier)() -> () -> WideAmount.ZERO));
    }

    public static WideAmountData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<WideAmount>> serverSideGetter) {
        return WideAmountData.of(container, isClientSide, (NonNullSupplier<Supplier<WideAmount>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static WideAmountData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<WideAmount>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        WideAmountData data = isClientSide ? new WideAmountData() : new WideAmountData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public IBindableData<Double> asDouble() {
        if (null == this._asDoubleBindable) {
            this._asDoubleBindable = AbstractData.as(0.0, doubleConsumer -> this.bind(wideAmount -> doubleConsumer.accept(wideAmount.doubleValue())));
        }
        return this._asDoubleBindable;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        WideAmount current = ((WideAmount)this._getter.get()).copy();
        if (this._lastValue.equals(current)) {
            return null;
        }
        this._lastValue = current;
        return current::serializeTo;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(WideAmount.from(dataSource));
    }

    @Override
    @Nullable
    public WideAmount defaultValue() {
        return WideAmount.ZERO;
    }

    private WideAmountData() {
    }

    private WideAmountData(NonNullSupplier<Supplier<WideAmount>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = WideAmount.ZERO;
    }
}

