/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.slot;

import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.ISlotFilter;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotType;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SlotTemplate {
    public static final SlotTemplate TEMPLATE_PLAYERINVENTORY = new SlotTemplate(SlotType.PlayerInventory);
    public static final SlotTemplate TEMPLATE_PLAYERHOTBAR = new SlotTemplate(SlotType.PlayerHotbar);
    private final SlotType _type;
    private final BiPredicate<Integer, ItemStack> _validator;

    public SlotTemplate(SlotType type) {
        this(type, SlotTemplate.getDefaultValidator(type));
    }

    public SlotTemplate(SlotType type, EnumSet<ItemHelper.MatchOption> filterOptions, ItemStack ... filterItemStacks) {
        this(type, (Integer slotIndex, ItemStack stack) -> {
            if (filterItemStacks.length > 0) {
                for (ItemStack filter : filterItemStacks) {
                    if (!ItemHelper.stackMatch(filter, stack, filterOptions)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public SlotTemplate(SlotType type, Class<?> filterItem) {
        this(type, (Integer slotIndex, ItemStack stack) -> !stack.m_41619_() && filterItem.isInstance(stack.m_41720_()));
    }

    public SlotTemplate(SlotType type, ISlotFilter filter) {
        this(type, filter::isStackAllowedForSlot);
    }

    public SlotType getType() {
        return this._type;
    }

    public Slot createSlot(SlotFactory slotFactory, IItemHandler inventory) {
        return slotFactory.getSlotType().slot(inventory, slotFactory);
    }

    public boolean match(int slotIndex, ItemStack stack) {
        return this._validator.test(slotIndex, stack);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (null == other || this.getClass() != other.getClass()) {
            return false;
        }
        return this._type == ((SlotTemplate)other)._type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._type});
    }

    private SlotTemplate(SlotType type, BiPredicate<Integer, ItemStack> validator) {
        this._type = type;
        this._validator = validator;
    }

    private static BiPredicate<Integer, ItemStack> getDefaultValidator(SlotType type) {
        switch (type) {
            case Input: 
            case GhostInput: 
            case PlayerInventory: 
            case PlayerHotbar: 
            case Special: {
                return (i, s) -> true;
            }
        }
        return (i, s) -> false;
    }
}

