/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.tag;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.data.WeakReferenceGroup;
import it.zerono.mods.zerocore.lib.tag.TagSource;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

public class TagList<T> {
    private static final WeakReferenceGroup<TagList<?>> s_lists = new WeakReferenceGroup();
    private final TagSource<T> _source;
    private final ObjectList<TagKey<T>> _ids;
    private final Object2ObjectMap<TagKey<T>, List<T>> _objects;

    public static <T> TagList<T> create(TagSource<T> source) {
        TagList<T> list = new TagList<T>(source);
        s_lists.add(list);
        return list;
    }

    public static <T> TagList<T> create(NonNullSupplier<Registry<T>> registrySupplier) {
        return TagList.create(new TagSource<T>(registrySupplier));
    }

    public static TagList<Block> blocks() {
        return TagList.create(TagsHelper.BLOCKS);
    }

    public static TagList<Item> items() {
        return TagList.create(TagsHelper.ITEMS);
    }

    public static TagList<Fluid> fluids() {
        return TagList.create(TagsHelper.FLUIDS);
    }

    public void addTag(TagKey<T> tagKey) {
        this._ids.add(tagKey);
    }

    public void addTag(ResourceLocation id) {
        this.addTag(this._source.createKey(id));
    }

    public void removeTag(TagKey<T> tagKey) {
        this._ids.remove(tagKey);
        this._objects.remove(tagKey);
    }

    public void removeTag(ResourceLocation id) {
        this.removeTag(this._source.createKey(id));
    }

    public void clear() {
        this._objects.clear();
        this._ids.clear();
    }

    public boolean contains(TagKey<T> tagKey) {
        return this._ids.contains(tagKey);
    }

    public boolean contains(ResourceLocation id) {
        return this.contains(this._source.createKey(id));
    }

    public Stream<TagKey<T>> stream() {
        return this._ids.stream();
    }

    public List<T> objects(TagKey<T> tagKey) {
        return (List)this._objects.getOrDefault(tagKey, (Object)ObjectLists.emptyList());
    }

    public Optional<T> first(TagKey<T> tagKey) {
        List<T> objects = this.objects(tagKey);
        return objects.isEmpty() ? Optional.empty() : Optional.ofNullable(objects.get(0));
    }

    public boolean match(Predicate<TagKey<T>> test) {
        return this._ids.stream().anyMatch(test);
    }

    public Optional<TagKey<T>> findFirst(Predicate<TagKey<T>> test) {
        return this._ids.stream().filter(test).findFirst();
    }

    public void forEach(Consumer<? super TagKey<T>> action) {
        this._ids.forEach(action);
    }

    public void forEach(TagKey<T> tagKey, Consumer<? super T> action) {
        this.objects(tagKey).forEach(action);
    }

    public static void initialize() {
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).addListener(EventPriority.LOWEST, e -> s_lists.forEach(TagList::updateTags));
    }

    private TagList(TagSource<T> source) {
        this._source = source;
        this._ids = new ObjectArrayList(8);
        this._objects = new Object2ObjectArrayMap(8);
        this._objects.defaultReturnValue((Object)ObjectLists.emptyList());
    }

    private void updateTags() {
        this._objects.clear();
        this._ids.forEach(key -> this._objects.put(key, this._source.getObjects((TagKey<T>)key)));
    }
}

