/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.text;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class BindableText
implements NonNullSupplier<Component> {
    protected final NonNullFunction<MutableComponent, MutableComponent> _postProcessor;
    protected Component _cachedText;

    public static <T> NonNullSupplier<Component> of(IBindableData<T> bindableData, Function<T, MutableComponent> textFactory) {
        return BindableText.of(bindableData, bindableData.defaultValue(), textFactory, TextHelper.IDENTITY_TEXT_POST_PROCESSOR);
    }

    public static <T> NonNullSupplier<Component> of(IBindableData<T> bindableData, @Nullable T initialValue, Function<T, MutableComponent> textFactory) {
        return BindableText.of(bindableData, initialValue, textFactory, TextHelper.IDENTITY_TEXT_POST_PROCESSOR);
    }

    public static <T> NonNullSupplier<Component> of(IBindableData<T> bindableData, @Nullable T initialValue, Function<T, MutableComponent> textFactory, NonNullFunction<MutableComponent, MutableComponent> postProcessor) {
        SingleBindableText<T> text = new SingleBindableText<T>(initialValue, textFactory, postProcessor);
        bindableData.bind(text::changeValue);
        return text;
    }

    public static <T, U> NonNullSupplier<Component> of(IBindableData<T> firstBindableData, IBindableData<U> secondBindableData, BiFunction<T, U, MutableComponent> textFactory) {
        return BindableText.of(firstBindableData, firstBindableData.defaultValue(), secondBindableData, secondBindableData.defaultValue(), textFactory, TextHelper.IDENTITY_TEXT_POST_PROCESSOR);
    }

    public static <T, U> NonNullSupplier<Component> of(IBindableData<T> firstBindableData, @Nullable T firstInitialValue, IBindableData<U> secondBindableData, @Nullable U secondInitialValue, BiFunction<T, U, MutableComponent> textFactory) {
        return BindableText.of(firstBindableData, firstInitialValue, secondBindableData, secondInitialValue, textFactory, TextHelper.IDENTITY_TEXT_POST_PROCESSOR);
    }

    public static <T, U> NonNullSupplier<Component> of(IBindableData<T> firstBindableData, @Nullable T firstInitialValue, IBindableData<U> secondBindableData, @Nullable U secondInitialValue, BiFunction<T, U, MutableComponent> textFactory, NonNullFunction<MutableComponent, MutableComponent> postProcessor) {
        BiBindableText<T, U> text = new BiBindableText<T, U>(firstInitialValue, secondInitialValue, textFactory, postProcessor);
        firstBindableData.bind(text::changeFirstValue);
        secondBindableData.bind(text::changeSecondValue);
        return text;
    }

    @Nullable
    protected abstract MutableComponent build();

    protected void reset() {
        this._cachedText = null;
    }

    @Nonnull
    public Component get() {
        if (null == this._cachedText) {
            MutableComponent text = this.build();
            this._cachedText = null != text ? (Component)this._postProcessor.apply((Object)text) : CodeHelper.TEXT_EMPTY_LINE;
        }
        return this._cachedText;
    }

    protected BindableText(NonNullFunction<MutableComponent, MutableComponent> postProcessor) {
        this._postProcessor = (NonNullFunction)Preconditions.checkNotNull(postProcessor, (Object)"Post processor must not be null.");
    }

    private static class SingleBindableText<T>
    extends BindableText {
        private final Function<T, MutableComponent> _textFactory;
        @Nullable
        private T _cachedValue;

        protected SingleBindableText(@Nullable T initialValue, Function<T, MutableComponent> textFactory, NonNullFunction<MutableComponent, MutableComponent> postProcessor) {
            super(postProcessor);
            this._textFactory = (Function)Preconditions.checkNotNull(textFactory, (Object)"Text factory must not be null.");
            this._cachedValue = initialValue;
        }

        @Override
        @Nullable
        protected MutableComponent build() {
            return null != this._cachedValue ? this._textFactory.apply(this._cachedValue) : null;
        }

        public void changeValue(T value) {
            this._cachedValue = value;
            this.reset();
        }
    }

    private static class BiBindableText<T, U>
    extends BindableText {
        private final BiFunction<T, U, MutableComponent> _textFactory;
        @Nullable
        private T _cachedFirstValue;
        @Nullable
        private U _cachedSecondValue;

        protected BiBindableText(@Nullable T firstInitialValue, @Nullable U secondInitialValue, BiFunction<T, U, MutableComponent> textFactory, NonNullFunction<MutableComponent, MutableComponent> postProcessor) {
            super(postProcessor);
            this._textFactory = (BiFunction)Preconditions.checkNotNull(textFactory, (Object)"Text factory must not be null.");
            this._cachedFirstValue = firstInitialValue;
            this._cachedSecondValue = secondInitialValue;
        }

        @Override
        @Nullable
        protected MutableComponent build() {
            if (null == this._cachedFirstValue || null == this._cachedSecondValue) {
                return null;
            }
            return this._textFactory.apply(this._cachedFirstValue, this._cachedSecondValue);
        }

        public void changeFirstValue(T value) {
            this._cachedFirstValue = value;
            this.reset();
        }

        public void changeSecondValue(U value) {
            this._cachedSecondValue = value;
            this.reset();
        }
    }
}

