/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageItemStack
implements IEnergyStorage {
    private final ItemStack stack;

    public EnergyStorageItemStack(ItemStack stack, int capacity) {
        this(stack, capacity, capacity, capacity, 0);
    }

    public EnergyStorageItemStack(ItemStack stack, int capacity, int maxReceive, int maxExtract, int energy) {
        this.stack = stack;
        CompoundTag tag = this.stack.m_41784_();
        CompoundTag nbt = new CompoundTag();
        if (!tag.m_128441_("Energy")) {
            nbt.m_128405_("MaxEnergyStored", capacity);
            nbt.m_128405_("MaxEnergyUse", maxReceive);
            nbt.m_128405_("MaxEnergyUse", maxExtract);
            nbt.m_128405_("EnergyStored", energy);
            tag.m_128365_("Energy", (Tag)nbt);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("Energy")) {
            CompoundTag energyStorage = tag.m_128469_("Energy");
            int capacity = energyStorage.m_128451_("MaxEnergyStored");
            int maxReceiveInternal = energyStorage.m_128451_("MaxEnergyUse");
            int energy = energyStorage.m_128451_("EnergyStored");
            if (maxReceiveInternal <= 0) {
                return 0;
            }
            int energyReceived = Math.min(capacity - energy, Math.min(maxReceiveInternal, maxReceive));
            if (!simulate) {
                energyStorage.m_128405_("EnergyStored", energy += energyReceived);
            }
            return energyReceived;
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("Energy")) {
            CompoundTag energyStorage = tag.m_128469_("Energy");
            int maxExtractInternal = energyStorage.m_128451_("MaxEnergyUse");
            int energy = energyStorage.m_128451_("EnergyStored");
            if (maxExtractInternal <= 0) {
                return 0;
            }
            int energyExtracted = Math.min(energy, Math.min(maxExtractInternal, maxExtract));
            if (!simulate) {
                energyStorage.m_128405_("EnergyStored", energy -= energyExtracted);
            }
            return energyExtracted;
        }
        return 0;
    }

    public int getEnergyStored() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("Energy") && tag.m_128469_("Energy").m_128441_("EnergyStored")) {
            return tag.m_128469_("Energy").m_128451_("EnergyStored");
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("Energy") && tag.m_128469_("Energy").m_128441_("MaxEnergyStored")) {
            return tag.m_128469_("Energy").m_128451_("MaxEnergyStored");
        }
        return 0;
    }

    public boolean canExtract() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("Energy") && tag.m_128469_("Energy").m_128441_("MaxEnergyUse")) {
            return tag.m_128469_("Energy").m_128451_("MaxEnergyUse") > 0;
        }
        return false;
    }

    public boolean canReceive() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("Energy") && tag.m_128469_("Energy").m_128441_("MaxEnergyUse")) {
            return tag.m_128469_("Energy").m_128451_("MaxEnergyUse") > 0;
        }
        return false;
    }
}

