/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import com.flanks255.simplygraves.GraveBlock;
import com.flanks255.simplygraves.GraveData;
import com.flanks255.simplygraves.GraveEntity;
import com.flanks255.simplygraves.PlayerPreferences;
import com.flanks255.simplygraves.SGBlocks;
import com.flanks255.simplygraves.SimplyGraves;
import com.flanks255.simplygraves.WSD.GraveStorage;
import com.flanks255.simplygraves.WSD.PreferenceStorage;
import com.flanks255.simplygraves.config.CommonConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.RegistryObject;

public class DropEvent {
    public static void Event(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntity().m_9236_().f_46443_) {
                Collection drops;
                PlayerPreferences prefs = PreferenceStorage.get().getPrefs(player.m_20148_());
                long time = System.currentTimeMillis();
                if (!prefs.getGraveOption().orElse((Boolean)CommonConfig.DEFAULT_GRAVE_OPTION.get()).booleanValue()) {
                    return;
                }
                if (time - prefs.getLastGrave() < (long)((Integer)CommonConfig.GRAVE_COOLDOWN.get() * 1000)) {
                    Duration timeLeft = Duration.ofSeconds((long)((Integer)CommonConfig.GRAVE_COOLDOWN.get()).intValue() - (time - prefs.getLastGrave()) / 1000L);
                    player.m_213846_((Component)Component.m_237110_((String)"simplygraves.cooldown", (Object[])new Object[]{timeLeft.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase()}).m_130938_(style -> style.m_131140_(ChatFormatting.RED)));
                    return;
                }
                if (prefs.getGraveOption().isEmpty()) {
                    player.m_213846_((Component)Component.m_237115_((String)((Boolean)CommonConfig.DEFAULT_GRAVE_OPTION.get() != false ? "simplygraves.server_enabled" : "simplygraves.server_disabled")));
                    player.m_213846_((Component)Component.m_237115_((String)"simplygraves.server_choice"));
                    MutableComponent optInLink = Component.m_237113_((String)"Opt-in");
                    optInLink.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sg option enable")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Enable Graves"))).m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)));
                    MutableComponent optOutLink = Component.m_237113_((String)"Opt-out");
                    optOutLink.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sg option disable")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Disable Graves"))).m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)));
                    player.m_213846_((Component)Component.m_237113_((String)"[").m_7220_((Component)optInLink).m_130946_("] - [").m_7220_((Component)optOutLink).m_130946_("]"));
                }
                if ((drops = event.getDrops()).isEmpty()) {
                    return;
                }
                ItemStackHandler inventory = new ItemStackHandler(drops.size());
                ArrayList toRemove = new ArrayList();
                drops.forEach(drop -> {
                    if (!drop.m_32055_().m_204117_(SimplyGraves.NO_GRAVE)) {
                        ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)drop.m_32055_(), (boolean)false);
                        toRemove.add(drop);
                    }
                });
                toRemove.forEach(drops::remove);
                UUID uuid = UUID.randomUUID();
                BlockPos pos = player.m_20097_().m_7494_();
                String name = player.m_7755_().getString();
                GraveStorage.get().addGrave(uuid, new GraveData(player.m_20148_(), name, uuid, pos, (ResourceKey<Level>)player.m_9236_().m_46472_(), time, inventory, false));
                Level level = player.m_9236_();
                BlockPos gravePos = DropEvent.search(level, pos);
                boolean replaceable = DropEvent.valid(level, gravePos);
                if (replaceable) {
                    RegistryObject<GraveBlock> block = SGBlocks.GRAVES.get(event.getEntity().m_9236_().f_46441_.m_188503_(SGBlocks.GRAVES.size()));
                    BlockState state = ((GraveBlock)((Object)block.get())).m_49966_();
                    if (level.m_7731_(gravePos, state, 3)) {
                        BlockEntity blockEntity;
                        if (level.m_8055_(gravePos).m_155947_() && (blockEntity = level.m_7702_(gravePos)) instanceof GraveEntity) {
                            GraveEntity entity = (GraveEntity)blockEntity;
                            SimplyGraves.LOGGER.info("Grave placed @ " + gravePos);
                            DropEvent.successGrave(player, uuid, gravePos, level.m_46472_().m_135782_().m_135815_());
                            entity.setGrave(uuid, player.m_20148_(), name, time);
                        } else {
                            DropEvent.failedGrave(player, uuid);
                        }
                    } else {
                        DropEvent.failedGrave(player, uuid);
                    }
                } else {
                    DropEvent.failedGrave(player, uuid);
                }
                prefs.setLastGrave(time);
            }
        }
    }

    private static void successGrave(Player player, UUID graveUUID, BlockPos pos, String dim) {
        player.m_213846_((Component)Component.m_237110_((String)"simplygraves.success", (Object[])new Object[]{Component.m_237113_((String)pos.m_123344_()).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)), Component.m_237113_((String)dim).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)), Component.m_237113_((String)graveUUID.toString().substring(0, 8)).m_130938_(style -> style.m_131140_(ChatFormatting.BLUE))}));
    }

    private static void failedGrave(Player player, UUID graveUUID) {
        SimplyGraves.LOGGER.info("Grave for " + player.m_7755_().getString() + " failed to place.");
        GraveStorage.get().setFailed(graveUUID);
        MutableComponent recover = Component.m_237113_((String)"Recover");
        recover.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sg failed")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Recover failed grave"))).m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)));
        player.m_213846_((Component)Component.m_237115_((String)"simplygraves.failed"));
        player.m_213846_((Component)Component.m_237113_((String)"    [").m_7220_((Component)recover).m_130946_("]"));
    }

    private static boolean valid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_247087_();
    }

    private static BlockHitResult checkColumn(Level level, BlockPos pos) {
        Vec3 start = Vec3.m_82512_((Vec3i)pos.m_6630_(4));
        Vec3 end = Vec3.m_82512_((Vec3i)pos);
        return level.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
    }

    private static BlockPos search(Level level, BlockPos deathPos) {
        if (DropEvent.valid(level, deathPos)) {
            return deathPos;
        }
        if (DropEvent.valid(level, deathPos.m_7494_())) {
            return deathPos.m_7494_();
        }
        BlockHitResult res1 = DropEvent.checkColumn(level, deathPos);
        if (res1.m_6662_() == HitResult.Type.BLOCK && DropEvent.valid(level, res1.m_82425_().m_7494_())) {
            return res1.m_82425_().m_7494_();
        }
        BlockHitResult res2 = DropEvent.checkColumn(level, deathPos.m_122012_());
        if (res2.m_6662_() == HitResult.Type.BLOCK && DropEvent.valid(level, res2.m_82425_().m_7494_())) {
            return res2.m_82425_().m_7494_();
        }
        BlockHitResult res3 = DropEvent.checkColumn(level, deathPos.m_122019_());
        if (res3.m_6662_() == HitResult.Type.BLOCK && DropEvent.valid(level, res3.m_82425_().m_7494_())) {
            return res3.m_82425_().m_7494_();
        }
        BlockHitResult res4 = DropEvent.checkColumn(level, deathPos.m_122029_());
        if (res4.m_6662_() == HitResult.Type.BLOCK && DropEvent.valid(level, res4.m_82425_().m_7494_())) {
            return res4.m_82425_().m_7494_();
        }
        BlockHitResult res5 = DropEvent.checkColumn(level, deathPos.m_122024_());
        if (res5.m_6662_() == HitResult.Type.BLOCK && DropEvent.valid(level, res5.m_82425_().m_7494_())) {
            return res5.m_82425_().m_7494_();
        }
        return deathPos;
    }
}

