/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import com.flanks255.simplygraves.Grave;
import com.flanks255.simplygraves.GraveEntity;
import com.flanks255.simplygraves.WSD.GraveStorage;
import com.flanks255.simplygraves.config.CommonConfig;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraveBlock
extends Block
implements EntityBlock {
    public final Grave graveType;

    public GraveBlock(Grave graveIn) {
        super(BlockBehaviour.Properties.m_284310_().m_280606_().m_60913_(200.0f, 3600000.0f).m_278166_(PushReaction.BLOCK));
        this.graveType = graveIn;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        return new GraveEntity(pPos, pState);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return this.graveType.shape;
    }

    @NotNull
    public InteractionResult m_6227_(@Nonnull BlockState pState, Level pLevel, @Nonnull BlockPos pPos, @Nonnull Player pPlayer, @Nonnull InteractionHand pHand, @Nonnull BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!pLevel.m_5776_() && !pPlayer.m_6047_() && pHand == InteractionHand.MAIN_HAND && pLevel.m_8055_(pPos).m_155947_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof GraveEntity) {
            GraveEntity entity = (GraveEntity)blockEntity;
            UUID playerUUID = pPlayer.m_20148_();
            entity.getUUID().ifPresent(uuid -> {
                GraveStorage storage = GraveStorage.get();
                if (storage.getGrave((UUID)uuid).isEmpty()) {
                    storage.removeGrave((UUID)uuid);
                    pLevel.m_46747_(pPos);
                    pLevel.m_7471_(pPos, false);
                    pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
                }
                storage.getGrave((UUID)uuid).ifPresent(graveData -> {
                    if (!playerUUID.equals(graveData.playerUUID) && graveData.deathTime + (long)((Integer)CommonConfig.DELAY_TO_PUBLIC.get() * 1000) > System.currentTimeMillis()) {
                        pPlayer.m_213846_((Component)Component.m_237110_((String)"simplygraves.not_yours", (Object[])new Object[]{graveData.playerName}));
                        return;
                    }
                    ItemStackHandler inv = graveData.inventory;
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        ItemStack stack = inv.getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)stack);
                    }
                    storage.removeGrave((UUID)uuid);
                    pLevel.m_46747_(pPos);
                    pLevel.m_7471_(pPos, false);
                    pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
                });
            });
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }
}

