/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GraveData
implements Comparable<GraveData> {
    public final UUID playerUUID;
    public final String playerName;
    public final UUID graveUUID;
    public BlockPos blockPos;
    public final ResourceKey<Level> dim;
    public final long deathTime;
    public final ItemStackHandler inventory;
    public boolean failed;

    public GraveData(UUID playerUUID, String playerName, UUID graveUUID, BlockPos blockPos, ResourceKey<Level> dim, long deathTime, ItemStackHandler inventory, boolean failed) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.graveUUID = graveUUID;
        this.blockPos = blockPos;
        this.dim = dim;
        this.deathTime = deathTime;
        this.inventory = inventory;
        this.failed = failed;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("PlayerUUID", this.playerUUID);
        tag.m_128359_("PlayerName", this.playerName);
        tag.m_128362_("GraveUUID", this.graveUUID);
        tag.m_128405_("X", this.blockPos.m_123341_());
        tag.m_128405_("Y", this.blockPos.m_123342_());
        tag.m_128405_("Z", this.blockPos.m_123343_());
        tag.m_128359_("Dim", this.dim.m_135782_().toString());
        tag.m_128356_("DeathTime", this.deathTime);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128379_("Failed", this.failed);
        return tag;
    }

    public static GraveData deserializeNBT(CompoundTag nbt) {
        UUID playerUUID = nbt.m_128342_("PlayerUUID");
        String playerName = nbt.m_128461_("PlayerName");
        UUID graveUUID = nbt.m_128342_("GraveUUID");
        int x = nbt.m_128451_("X");
        int y = nbt.m_128451_("Y");
        int z = nbt.m_128451_("Z");
        ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("Dim")));
        BlockPos blockPos = new BlockPos(x, y, z);
        long deathTime = nbt.m_128454_("DeathTime");
        ItemStackHandler inventory = new ItemStackHandler();
        inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        boolean failed = false;
        if (nbt.m_128441_("Failed")) {
            failed = nbt.m_128471_("Failed");
        }
        return new GraveData(playerUUID, playerName, graveUUID, blockPos, (ResourceKey<Level>)dim, deathTime, inventory, failed);
    }

    @Override
    public int compareTo(@NotNull GraveData o) {
        return Long.compare(o.deathTime, this.deathTime);
    }
}

