/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class PlayerPreferences {
    private Optional<Boolean> graveOption;
    private final UUID player;
    private long lastGrave;

    private PlayerPreferences(CompoundTag nbt) {
        this.player = nbt.m_128342_("uuid");
        this.graveOption = nbt.m_128441_("graveoption") ? Optional.of(nbt.m_128471_("graveoption")) : Optional.empty();
        this.lastGrave = nbt.m_128441_("lastGrave") ? nbt.m_128454_("lastGrave") : 0L;
    }

    public PlayerPreferences(UUID player) {
        this.player = player;
        this.graveOption = Optional.empty();
        this.lastGrave = 0L;
    }

    public static PlayerPreferences of(CompoundTag nbt) {
        return new PlayerPreferences(nbt);
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("uuid", this.player);
        this.graveOption.ifPresent($ -> nbt.m_128379_("graveoption", $.booleanValue()));
        nbt.m_128356_("lastGrave", this.lastGrave);
        return nbt;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public Optional<Boolean> getGraveOption() {
        return this.graveOption;
    }

    public void setGraveOption(boolean option) {
        this.graveOption = Optional.of(option);
    }

    public long getLastGrave() {
        return this.lastGrave;
    }

    public void setLastGrave(long time) {
        this.lastGrave = time;
    }
}

