/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves.commands;

import com.flanks255.simplygraves.GraveData;
import com.flanks255.simplygraves.WSD.GraveStorage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class List {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(cs -> cs.m_6761_(1))).executes(cs -> List.list((CommandContext<CommandSourceStack>)cs, ""))).then(Commands.m_82129_((String)"PlayerName", (ArgumentType)StringArgumentType.string()).suggests((cs, builder) -> SharedSuggestionProvider.m_82970_(List.getPlayerSuggestions((CommandContext<CommandSourceStack>)cs), (SuggestionsBuilder)builder)).executes(cs -> List.list((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"PlayerName"))));
    }

    public static Set<String> getPlayerSuggestions(CommandContext<CommandSourceStack> commandSource) {
        HashSet<String> list = new HashSet<String>();
        ((CommandSourceStack)commandSource.getSource()).m_81377_().m_6846_().m_11314_().forEach(serverPlayerEntity -> list.add(serverPlayerEntity.m_7755_().getString()));
        return list;
    }

    public static int list(CommandContext<CommandSourceStack> ctx, String playername) {
        GraveStorage storage = GraveStorage.get();
        HashMap<UUID, GraveData> data = storage.getData();
        if (data.size() == 0) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"[ ]"), false);
            return 0;
        }
        if (Objects.equals(playername, "")) {
            data.forEach((uuid, grave) -> List.sendGrave((Player)((CommandSourceStack)ctx.getSource()).m_230896_(), grave));
        } else {
            data.forEach((uuid, grave) -> {
                if (grave.playerName.equalsIgnoreCase(playername)) {
                    List.sendGrave((Player)((CommandSourceStack)ctx.getSource()).m_230896_(), grave);
                }
            });
        }
        return 0;
    }

    public static void sendGrave(Player player, GraveData graveData) {
        player.m_213846_((Component)Component.m_237113_((String)"===========================").m_130940_(ChatFormatting.DARK_GRAY));
        player.m_213846_((Component)Component.m_237113_((String)(graveData.graveUUID.toString().substring(0, 8) + "...\n" + graveData.playerName + "\n" + SDF.format(new Date(graveData.deathTime)))));
    }
}

