/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves.render;

import com.flanks255.simplygraves.GraveEntity;
import com.flanks255.simplygraves.config.CommonConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.text.SimpleDateFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GraveTextRender
implements BlockEntityRenderer<GraveEntity> {
    private static final SimpleDateFormat format = new SimpleDateFormat("mm:ss");

    public void render(@Nonnull GraveEntity graveEntity, float pPartialTick, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
        matrixStack.m_85841_(0.03f, 0.03f, 0.03f);
        Vec3 cameraPos = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
        BlockPos gravePos = graveEntity.m_58899_();
        boolean isMine = graveEntity.getPlayer().compareTo(Minecraft.m_91087_().f_91074_.m_20148_()) == 0;
        double angle = Mth.m_14136_((double)(cameraPos.f_82481_ - (double)((float)gravePos.m_123343_() + 0.5f)), (double)(cameraPos.f_82479_ - (double)((float)gravePos.m_123341_() + 0.5f)));
        matrixStack.m_252781_(Axis.f_252436_.m_252961_((float)(1.5707963267948966 - (double)((float)angle))));
        Font font = Minecraft.m_91087_().f_91062_;
        this.drawCenteredString(matrixStack, font, graveEntity.getPlayerName(), 0, -25, 0xFFFFFF, pBufferSource);
        long timeRemaining = 0L;
        if (!isMine && (timeRemaining = graveEntity.getDeathTime() + (long)((Integer)CommonConfig.DELAY_TO_PUBLIC.get() * 1000) - System.currentTimeMillis()) > 0L) {
            matrixStack.m_252880_(0.0f, -15.0f, 0.0f);
            matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
            this.drawCenteredString(matrixStack, font, format.format(timeRemaining), 0, 0, 0xFFFF00, pBufferSource);
        }
        if (isMine || timeRemaining == 0L) {
            matrixStack.m_252880_(0.0f, -15.0f, 0.0f);
            matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
            this.drawCenteredString(matrixStack, font, "Right-click to collect.", 0, 0, 0xFFFFFF, pBufferSource);
        }
        matrixStack.m_85849_();
    }

    private void drawCenteredString(PoseStack matrixStack, Font font, String string, int x, int y, int color, @NotNull MultiBufferSource pBufferSource) {
        float offset = (float)(-font.m_92895_(string)) / 2.0f;
        font.m_271703_(string, (float)x + offset, (float)y, color, false, matrixStack.m_85850_().m_252922_(), pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public int m_142163_() {
        return 10;
    }
}

