/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.ItemCraftedEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingGuideButtonFixer;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksClientAPI;
import net.blay09.mods.craftingtweaks.api.GridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.InternalClientMethodsImpl;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClientProviderManager;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksDebugger;
import net.blay09.mods.craftingtweaks.client.ModKeyMappings;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksMode;
import net.blay09.mods.craftingtweaks.network.BalanceMessage;
import net.blay09.mods.craftingtweaks.network.ClearMessage;
import net.blay09.mods.craftingtweaks.network.CompressMessage;
import net.blay09.mods.craftingtweaks.network.CraftStackMessage;
import net.blay09.mods.craftingtweaks.network.RotateMessage;
import net.blay09.mods.craftingtweaks.network.TransferStackMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class CraftingTweaksClient {
    private static final ClientProvider clientProvider = new ClientProvider();
    private static boolean ignoreMouseUp;
    private static int rightClickCraftingSlot;
    private static Button unpleasantButton;
    private static int fixedUnpleasantButtonX;

    public static void initialize() {
        CraftingTweaksClientAPI.setupAPI(new InternalClientMethodsImpl());
        CraftingTweaksClientAPI.registerCraftingGridGuiHandler(AbstractContainerScreen.class, new DefaultGridGuiHandler());
        ModKeyMappings.initialize();
        Balm.getEvents().onEvent(ItemCraftedEvent.class, CraftingTweaksClient::onItemCrafted);
        Balm.getEvents().onEvent(ConnectedToServerEvent.class, it -> {
            CraftingTweaks.isServerSideInstalled = false;
        });
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, CraftingTweaksClient::screenInitialized);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Post.class, CraftingTweaksClient::screenKeyPressed);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, CraftingTweaksClient::screenMouseClick);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, CraftingTweaksClient::screenMouseRelease);
        Balm.getEvents().onEvent(ScreenDrawEvent.Pre.class, CraftingTweaksClient::screenAboutToDraw);
        Balm.getEvents().onEvent(ScreenDrawEvent.Post.class, CraftingTweaksClient::screenDrawn);
        CraftingTweaksDebugger.initialize();
    }

    public static boolean screenKeyPressed(ScreenKeyEvent event) {
        Screen screen = event.getScreen();
        int key = event.getKey();
        int scanCode = event.getScanCode();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null) {
            return false;
        }
        if (!(screen instanceof AbstractContainerScreen)) {
            return false;
        }
        Window window = Minecraft.m_91087_().m_91268_();
        if (CraftingTweaks.isServerSideInstalled && GLFW.glfwGetKey((long)window.m_85439_(), (int)66) == 1 && GLFW.glfwGetKey((long)window.m_85439_(), (int)76) == 1 && GLFW.glfwGetKey((long)window.m_85439_(), (int)65) == 1 && (GLFW.glfwGetKey((long)window.m_85439_(), (int)89) == 1 || GLFW.glfwGetKey((long)window.m_85439_(), (int)90) == 1)) {
            CraftingTweaks.isServerSideInstalled = false;
            player.m_5661_((Component)Component.m_237113_((String)"[CraftingTweaks] Enabled client-side testing mode"), false);
        }
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        CompressType compressType = ModKeyMappings.getCompressTypeForKey(key, scanCode, event.getModifiers());
        if (grid != null) {
            Slot mouseSlot;
            String modId = grid.getId().m_135827_();
            CraftingTweaksMode config = CraftingTweaksConfig.getActive().getCraftingTweaksMode(modId);
            if (config == CraftingTweaksMode.DEFAULT || config == CraftingTweaksMode.HOTKEYS) {
                boolean isRotate = ModKeyMappings.keyRotate.isActiveAndMatchesKey(key, scanCode, event.getModifiers());
                boolean isRotateCCW = ModKeyMappings.keyRotateCounterClockwise.isActiveAndMatchesKey(key, scanCode, event.getModifiers());
                boolean isBalance = ModKeyMappings.keyBalance.isActiveAndMatchesKey(key, scanCode, event.getModifiers());
                boolean isSpread = ModKeyMappings.keySpread.isActiveAndMatchesKey(key, scanCode, event.getModifiers());
                boolean isClear = ModKeyMappings.keyClear.isActiveAndMatchesKey(key, scanCode, event.getModifiers());
                boolean isForceClear = ModKeyMappings.keyForceClear.isActiveAndMatchesKey(key, scanCode, event.getModifiers());
                boolean isRefill = ModKeyMappings.keyRefillLast.isActiveAndMatchesKey(key, scanCode, event.getModifiers());
                boolean isRefillStack = ModKeyMappings.keyRefillLastStack.isActiveAndMatchesKey(key, scanCode, event.getModifiers());
                if (isRotate || isRotateCCW) {
                    if (CraftingTweaks.isServerSideInstalled) {
                        Balm.getNetworking().sendToServer((Object)new RotateMessage(grid.getId(), isRotateCCW));
                    } else {
                        clientProvider.rotateGrid((Player)player, menu, grid, isRotateCCW);
                    }
                    return true;
                }
                if (isClear || isForceClear) {
                    if (CraftingTweaks.isServerSideInstalled) {
                        Balm.getNetworking().sendToServer((Object)new ClearMessage(grid.getId(), isForceClear));
                    } else {
                        clientProvider.clearGrid((Player)player, menu, grid, isForceClear);
                    }
                    return true;
                }
                if (isBalance || isSpread) {
                    if (CraftingTweaks.isServerSideInstalled) {
                        Balm.getNetworking().sendToServer((Object)new BalanceMessage(grid.getId(), isSpread));
                    } else if (isSpread) {
                        clientProvider.spreadGrid((Player)player, menu, grid);
                    } else {
                        clientProvider.balanceGrid((Player)player, menu, grid);
                    }
                    return true;
                }
                if (isRefill || isRefillStack) {
                    if (CraftingTweaks.isServerSideInstalled) {
                        clientProvider.refillLastCrafted((Player)player, menu, grid, isRefillStack);
                    } else {
                        clientProvider.refillLastCrafted((Player)player, menu, grid, isRefillStack);
                    }
                    return true;
                }
            }
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (compressType != null && (mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot()) != null) {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.getNetworking().sendToServer((Object)new CompressMessage(mouseSlot.f_40219_, compressType));
                } else {
                    clientProvider.compress(player, menu, grid, mouseSlot, compressType);
                }
                return true;
            }
        } else if (CraftingTweaks.isServerSideInstalled) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (compressType != null) {
                Slot mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                if (mouseSlot != null) {
                    Balm.getNetworking().sendToServer((Object)new CompressMessage(mouseSlot.f_40219_, compressType));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean screenMouseRelease(ScreenMouseEvent event) {
        if (ignoreMouseUp) {
            ignoreMouseUp = false;
            return true;
        }
        return false;
    }

    public static boolean screenMouseClick(ScreenMouseEvent event) {
        Screen screen = event.getScreen();
        int button = event.getButton();
        rightClickCraftingSlot = -1;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null) {
            return false;
        }
        Slot mouseSlot = screen instanceof AbstractContainerScreen ? ((AbstractContainerScreenAccessor)screen).getHoveredSlot() : null;
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        if (grid != null) {
            if (ModKeyMappings.keyTransferStack.isActiveAndDown()) {
                if (mouseSlot != null && mouseSlot.m_6657_()) {
                    ArrayList transferSlots = Lists.newArrayList();
                    transferSlots.add(mouseSlot);
                    if (Screen.m_96638_()) {
                        ItemStack mouseSlotStack = mouseSlot.m_7993_();
                        for (Slot slot : menu.f_38839_) {
                            ItemStack slotStack;
                            if (!slot.m_6657_() || mouseSlot == slot || !ItemStack.m_150942_((ItemStack)(slotStack = slot.m_7993_()), (ItemStack)mouseSlotStack)) continue;
                            transferSlots.add(slot);
                        }
                    }
                    if (CraftingTweaks.isServerSideInstalled) {
                        for (Slot slot : transferSlots) {
                            Balm.getNetworking().sendToServer((Object)new TransferStackMessage(grid.getId(), slot.f_40219_));
                        }
                    } else {
                        for (Slot slot : transferSlots) {
                            clientProvider.transferIntoGrid((Player)player, menu, grid, slot);
                        }
                        ignoreMouseUp = true;
                    }
                    return true;
                }
            } else if (CraftingTweaksConfig.getActive().client.rightClickCraftsStack && button == 1 && mouseSlot instanceof ResultSlot) {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.getNetworking().sendToServer((Object)new CraftStackMessage(mouseSlot.f_40219_));
                } else {
                    rightClickCraftingSlot = mouseSlot.f_40219_;
                }
                ignoreMouseUp = true;
                return true;
            }
        }
        return false;
    }

    public static void screenInitialized(ScreenInitEvent event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            unpleasantButton = CraftingGuideButtonFixer.fixMistakes((AbstractContainerScreen)screen);
            if (unpleasantButton != null) {
                fixedUnpleasantButtonX = unpleasantButton.m_252754_();
            }
        } else {
            unpleasantButton = null;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            GridGuiHandler guiHandler = CraftingTweaksClientProviderManager.getGridGuiHandler(containerScreen);
            List<CraftingGrid> grids = CraftingTweaksProviderManager.getCraftingGrids(((AbstractContainerScreen)screen).m_6262_());
            for (CraftingGrid grid : grids) {
                String modId = grid.getId().m_135827_();
                CraftingTweaksMode config = CraftingTweaksConfig.getActive().getCraftingTweaksMode(modId);
                if (config != CraftingTweaksMode.DEFAULT && config != CraftingTweaksMode.BUTTONS) continue;
                guiHandler.createButtons(containerScreen, grid, widget -> BalmClient.getScreens().addRenderableWidget(screen, widget));
            }
        }
    }

    private static void handleRightClickCrafting() {
        if (rightClickCraftingSlot == -1) {
            return;
        }
        int craftingSlot = rightClickCraftingSlot;
        rightClickCraftingSlot = -1;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        MultiPlayerGameMode playerController = Minecraft.m_91087_().f_91072_;
        if (playerController == null) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null) {
            return;
        }
        if (craftingSlot >= menu.f_38839_.size()) {
            return;
        }
        Slot mouseSlot = (Slot)menu.f_38839_.get(craftingSlot);
        if (!mouseSlot.m_6657_()) {
            rightClickCraftingSlot = mouseSlot.f_40219_;
            return;
        }
        ItemStack mouseStack = menu.m_142621_();
        if (mouseStack.m_41619_() || mouseStack.m_41613_() + mouseSlot.m_7993_().m_41613_() <= mouseStack.m_41741_()) {
            playerController.m_171799_(menu.f_38840_, mouseSlot.f_40219_, 0, ClickType.PICKUP, (Player)player);
            rightClickCraftingSlot = mouseSlot.f_40219_;
        }
    }

    public static void screenAboutToDraw(ScreenDrawEvent event) {
        Screen screen = event.getScreen();
        if (screen == null) {
            return;
        }
        if (screen instanceof AbstractContainerScreen) {
            int unpleasantX;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (unpleasantButton != null && (unpleasantX = unpleasantButton.m_252754_()) != fixedUnpleasantButtonX && (unpleasantButton = CraftingGuideButtonFixer.fixMistakes(containerScreen)) != null) {
                fixedUnpleasantButtonX = unpleasantButton.m_252754_();
            }
        }
    }

    public static void screenDrawn(ScreenDrawEvent event) {
        Screen screen = event.getScreen();
        if (screen == null) {
            return;
        }
        CraftingTweaksClient.handleRightClickCrafting();
    }

    private static void onItemCrafted(ItemCraftedEvent event) {
        clientProvider.onItemCrafted(event.getCraftMatrix());
    }

    public static ClientProvider getClientProvider() {
        return clientProvider;
    }

    static {
        rightClickCraftingSlot = -1;
    }
}

