/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mcjty.lib.crafting.CopyNBTRecipeBuilder;
import mcjty.lib.crafting.IRecipeBuilder;
import mcjty.lib.datagen.BaseBlockStateProvider;
import mcjty.lib.datagen.BaseBlockTagsProvider;
import mcjty.lib.datagen.BaseItemModelProvider;
import mcjty.lib.datagen.BaseLootTableProvider;
import mcjty.lib.datagen.BaseRecipeProvider;
import mcjty.lib.datagen.Dob;
import mcjty.lib.datagen.IRecipeFactory;
import mcjty.lib.datagen.ITagFactory;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class DataGen {
    private final String modid;
    private final GatherDataEvent event;
    private final List<Dob> dobs = new ArrayList<Dob>();
    private final Map<String, CodecProvider> codecProviders = new HashMap<String, CodecProvider>();

    public DataGen(String modid, GatherDataEvent event) {
        this.modid = modid;
        this.event = event;
    }

    public void addCodecProvider(String name, String directory, Codec codec) {
        this.codecProviders.put(name, new CodecProvider(directory, codec));
    }

    public void add(Dob.Builder ... builder) {
        for (Dob.Builder b : builder) {
            this.dobs.add(b.build());
        }
    }

    public void generate() {
        DataGenerator generator = this.event.getGenerator();
        generator.addProvider(this.event.includeServer(), (DataProvider)new GlobalLootModifierProvider(generator.getPackOutput(), this.modid){

            protected void start() {
                for (Dob dob : DataGen.this.dobs) {
                    for (Map.Entry<String, Supplier<IGlobalLootModifier>> entry : dob.glmSupplier().entrySet()) {
                        this.add(entry.getKey(), entry.getValue().get());
                    }
                }
            }
        });
        for (Map.Entry<String, CodecProvider> entry : this.codecProviders.entrySet()) {
            for (Dob dob : this.dobs) {
                Map entries = dob.codecObjectSupplier().getOrDefault(entry.getKey(), Collections::emptyMap).get();
                if (entries.isEmpty()) continue;
                generator.addProvider(this.event.includeServer(), (DataProvider)new JsonCodecProvider(generator.getPackOutput(), this.event.getExistingFileHelper(), this.modid, (DynamicOps)JsonOps.INSTANCE, PackType.SERVER_DATA, entry.getValue().directory(), entry.getValue().codec(), entries));
            }
        }
        generator.addProvider(this.event.includeServer(), (DataProvider)new BaseRecipeProvider(generator){

            protected void m_245200_(final Consumer<FinishedRecipe> consumer) {
                for (Dob dob : DataGen.this.dobs) {
                    dob.recipe().accept(new IRecipeFactory(){

                        @Override
                        public void recipe(Supplier<IRecipeBuilder> supplier) {
                            supplier.get().build(consumer);
                        }

                        @Override
                        public void recipeConsumer(Supplier<Consumer<Consumer<FinishedRecipe>>> consumerSupplier) {
                            consumerSupplier.get().accept(consumer);
                        }

                        @Override
                        public void recipe(String id, Supplier<IRecipeBuilder> supplier) {
                            supplier.get().build((Consumer<FinishedRecipe>)consumer, new ResourceLocation(DataGen.this.modid, id));
                        }

                        @Override
                        public void shapedNBT(CopyNBTRecipeBuilder builder, String ... pattern) {
                            this.build((Consumer<FinishedRecipe>)consumer, builder, pattern);
                        }

                        @Override
                        public void shapedNBT(String id, CopyNBTRecipeBuilder builder, String ... pattern) {
                            this.build((Consumer<FinishedRecipe>)consumer, new ResourceLocation(DataGen.this.modid, id), builder, pattern);
                        }

                        @Override
                        public void shaped(ShapedRecipeBuilder builder, String ... pattern) {
                            this.build((Consumer<FinishedRecipe>)consumer, builder, pattern);
                        }

                        @Override
                        public void shaped(String id, ShapedRecipeBuilder builder, String ... pattern) {
                            this.build((Consumer<FinishedRecipe>)consumer, new ResourceLocation(DataGen.this.modid, id), builder, pattern);
                        }

                        @Override
                        public void shapeless(ShapelessRecipeBuilder builder) {
                            this.build(consumer, builder);
                        }

                        @Override
                        public void shapeless(String id, ShapelessRecipeBuilder builder) {
                            this.build((Consumer<FinishedRecipe>)consumer, new ResourceLocation(DataGen.this.modid, id), builder);
                        }
                    });
                }
            }
        });
        BaseLootTableProvider lootTableProvider = new BaseLootTableProvider();
        List<LootTableProvider.SubProviderEntry> list = List.of(new LootTableProvider.SubProviderEntry(() -> biConsumer -> {
            for (Dob dob : this.dobs) {
                if (dob.blockSupplier() == null) continue;
                dob.loot().accept(lootTableProvider);
            }
        }, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(() -> biConsumer -> {
            for (Dob dob : this.dobs) {
                if (dob.entitySupplier() == null) continue;
                dob.loot().accept(lootTableProvider);
            }
        }, LootContextParamSets.f_81415_));
        generator.addProvider(this.event.includeServer(), (DataProvider)new LootTableProvider(generator.getPackOutput(), Collections.emptySet(), list));
        BaseBlockTagsProvider blockTags = new BaseBlockTagsProvider(generator, this.event.getLookupProvider(), this.modid, this.event.getExistingFileHelper()){

            @Override
            protected void m_6577_(HolderLookup.Provider provider) {
                for (Dob dob : DataGen.this.dobs) {
                    dob.blockTags().accept(new ITagFactory(){

                        @Override
                        public void blockTags(Supplier<? extends Block> blockSupplier, List<TagKey> tags) {
                            for (TagKey tag : tags) {
                                this.m_206424_(tag).m_255245_((Object)blockSupplier.get());
                            }
                        }

                        @Override
                        public void itemTags(Supplier<? extends Item> itemSupplier, List<TagKey> tags) {
                        }
                    });
                }
            }
        };
        generator.addProvider(this.event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(this.event.includeServer(), (DataProvider)new ItemTagsProvider(generator.getPackOutput(), this.event.getLookupProvider(), blockTags.m_274426_(), this.modid, this.event.getExistingFileHelper()){

            protected void m_6577_(HolderLookup.Provider provider) {
                for (Dob dob : DataGen.this.dobs) {
                    dob.itemTags().accept(new ITagFactory(){

                        @Override
                        public void blockTags(Supplier<? extends Block> blockSupplier, List<TagKey> tags) {
                        }

                        @Override
                        public void itemTags(Supplier<? extends Item> itemSupplier, List<TagKey> tags) {
                            for (TagKey tag : tags) {
                                this.m_206424_(tag).m_255245_((Object)itemSupplier.get());
                            }
                        }
                    });
                }
            }
        });
        generator.addProvider(this.event.includeClient(), (DataProvider)new LanguageProvider(generator.getPackOutput(), this.modid, "en_us"){

            protected void addTranslations() {
                for (Dob dob : DataGen.this.dobs) {
                    String name = dob.translatedName();
                    if (name != null) {
                        if (dob.blockSupplier() != null) {
                            this.add(dob.blockSupplier().get(), name);
                        } else if (dob.itemSupplier() != null) {
                            this.add(dob.itemSupplier().get(), name);
                        } else if (dob.entitySupplier() != null) {
                            this.add(dob.entitySupplier().get(), name);
                        }
                    }
                    Map<String, String> keyedMessages = dob.keyedMessages();
                    for (Map.Entry<String, String> entry : keyedMessages.entrySet()) {
                        String key;
                        if (dob.blockSupplier() != null) {
                            key = Util.m_137492_((String)"message", (ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)dob.blockSupplier().get()));
                        } else if (dob.itemSupplier() != null) {
                            key = Util.m_137492_((String)"message", (ResourceLocation)ForgeRegistries.ITEMS.getKey((Object)dob.itemSupplier().get()));
                        } else if (dob.entitySupplier() != null) {
                            key = Util.m_137492_((String)"message", (ResourceLocation)ForgeRegistries.ENTITY_TYPES.getKey((Object)dob.entitySupplier().get()));
                        } else {
                            throw new RuntimeException("Not supported!");
                        }
                        this.add(key + "." + entry.getKey(), entry.getValue());
                    }
                    Map<String, String> messages = dob.messages();
                    for (Map.Entry<String, String> entry : messages.entrySet()) {
                        this.add(entry.getKey(), entry.getValue());
                    }
                }
            }
        });
        generator.addProvider(this.event.includeClient(), (DataProvider)new BaseBlockStateProvider(generator, this.modid, this.event.getExistingFileHelper()){

            protected void registerStatesAndModels() {
                for (Dob dob : DataGen.this.dobs) {
                    dob.blockstate().accept(this);
                }
            }
        });
        generator.addProvider(this.event.includeClient(), (DataProvider)new BaseItemModelProvider(generator, this.modid, this.event.getExistingFileHelper()){

            protected void registerModels() {
                7 provider = this;
                for (Dob dob : DataGen.this.dobs) {
                    dob.item().accept(provider);
                }
            }
        });
    }

    public static InventoryChangeTrigger.TriggerInstance has(ItemLike item) {
        return DataGen.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> tag) {
        return DataGen.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... itemPredicate) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, itemPredicate);
    }

    record CodecProvider(String directory, Codec codec) {
    }
}

