/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaCrystalCubeBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.AssemblyHaloItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.WorldshaperssSextantItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;
import vazkii.botania.common.item.equipment.bauble.RingOfDexterousMotionItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.ClientXplatAbstractions;
import vazkii.botania.xplat.XplatAbstractions;

public final class HUDHandler {
    public static final ResourceLocation manaBar = new ResourceLocation("botania:textures/gui/mana_hud.png");
    private static boolean didOptifineDetection = false;

    private HUDHandler() {
    }

    public static void tryOptifineWarning() {
        if (!didOptifineDetection) {
            try {
                Class.forName("optifine.Installer");
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"botaniamisc.optifine_warning"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            didOptifineDetection = true;
        }
    }

    public static void onDrawScreenPost(GuiGraphics gui, float partialTicks) {
        EntityHitResult result;
        WandHUD hud;
        HitResult pos;
        PoseStack ms = gui.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        ProfilerFiller profiler = mc.m_91307_();
        ItemStack main = mc.f_91074_.m_21205_();
        ItemStack offhand = mc.f_91074_.m_21206_();
        profiler.m_6180_("botania-hud");
        if (Minecraft.m_91087_().f_91072_.m_105205_()) {
            ItemStack dodgeRing;
            ItemStack tiara = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, (LivingEntity)mc.f_91074_);
            if (!tiara.m_41619_()) {
                profiler.m_6180_("flugelTiara");
                FlugelTiaraItem.ClientLogic.renderHUD(gui, (Player)mc.f_91074_, tiara);
                profiler.m_7238_();
            }
            if (!(dodgeRing = EquipmentHandler.findOrEmpty(BotaniaItems.dodgeRing, (LivingEntity)mc.f_91074_)).m_41619_()) {
                profiler.m_6180_("dodgeRing");
                RingOfDexterousMotionItem.ClientLogic.renderHUD(gui, (Player)mc.f_91074_, dodgeRing, partialTicks);
                profiler.m_7238_();
            }
        }
        if ((pos = mc.f_91077_) instanceof BlockHitResult) {
            BlockHitResult result2 = (BlockHitResult)pos;
            BlockPos bpos = result2.m_82425_();
            BlockState state = mc.f_91073_.m_8055_(bpos);
            BlockEntity tile = mc.f_91073_.m_7702_(bpos);
            if (PlayerHelper.hasAnyHeldItem((Player)mc.f_91074_)) {
                boolean alternateRecipeHudPosition = false;
                if (PlayerHelper.hasHeldItemClass((Player)mc.f_91074_, WandOfTheForestItem.class)) {
                    HUDHandler.tryOptifineWarning();
                    WandHUD hud2 = ClientXplatAbstractions.INSTANCE.findWandHud((Level)mc.f_91073_, bpos, state, tile);
                    if (hud2 != null) {
                        alternateRecipeHudPosition = true;
                        profiler.m_6180_("wandItem");
                        hud2.renderHUD(gui, mc);
                        profiler.m_7238_();
                    }
                }
                if (tile instanceof ManaPoolBlockEntity) {
                    ManaPoolBlockEntity pool = (ManaPoolBlockEntity)tile;
                    if (!mc.f_91074_.m_21205_().m_41619_()) {
                        HUDHandler.renderPoolRecipeHUD(gui, pool, mc.f_91074_.m_21205_(), alternateRecipeHudPosition);
                    }
                }
            }
            if (!PlayerHelper.hasHeldItem((Player)mc.f_91074_, BotaniaItems.lexicon)) {
                if (tile instanceof PetalApothecaryBlockEntity) {
                    PetalApothecaryBlockEntity altar = (PetalApothecaryBlockEntity)tile;
                    PetalApothecaryBlockEntity.Hud.render(altar, gui, mc);
                } else if (tile instanceof RunicAltarBlockEntity) {
                    RunicAltarBlockEntity runeAltar = (RunicAltarBlockEntity)tile;
                    RunicAltarBlockEntity.Hud.render(runeAltar, gui, mc);
                } else if (tile instanceof CorporeaCrystalCubeBlockEntity) {
                    CorporeaCrystalCubeBlockEntity cube = (CorporeaCrystalCubeBlockEntity)tile;
                    CorporeaCrystalCubeBlockEntity.Hud.render(gui, cube);
                }
            }
        } else if (pos instanceof EntityHitResult && (hud = ClientXplatAbstractions.INSTANCE.findWandHud((result = (EntityHitResult)pos).m_82443_())) != null && PlayerHelper.hasHeldItemClass((Player)mc.f_91074_, WandOfTheForestItem.class)) {
            profiler.m_6180_("wandItemEntityHud");
            hud.renderHUD(gui, mc);
            profiler.m_7238_();
        }
        if (!CorporeaIndexBlockEntity.getNearbyValidIndexes((Player)mc.f_91074_).isEmpty() && mc.f_91080_ instanceof ChatScreen) {
            profiler.m_6180_("nearIndex");
            HUDHandler.renderNearIndexDisplay(gui);
            profiler.m_7238_();
        }
        if (!main.m_41619_() && main.m_41720_() instanceof AssemblyHaloItem) {
            profiler.m_6180_("craftingHalo_main");
            AssemblyHaloItem.Rendering.renderHUD(gui, (Player)mc.f_91074_, main);
            profiler.m_7238_();
        } else if (!offhand.m_41619_() && offhand.m_41720_() instanceof AssemblyHaloItem) {
            profiler.m_6180_("craftingHalo_off");
            AssemblyHaloItem.Rendering.renderHUD(gui, (Player)mc.f_91074_, offhand);
            profiler.m_7238_();
        }
        if (!main.m_41619_() && main.m_41720_() instanceof WorldshaperssSextantItem) {
            profiler.m_6180_("sextant");
            WorldshaperssSextantItem.Hud.render(gui, (Player)mc.f_91074_, main);
            profiler.m_7238_();
        }
        if (ManaseerMonocleItem.hasMonocle((LivingEntity)mc.f_91074_)) {
            profiler.m_6180_("monocle");
            ManaseerMonocleItem.Hud.render(gui, (Player)mc.f_91074_);
            profiler.m_7238_();
        }
        profiler.m_6180_("manaBar");
        LocalPlayer player = mc.f_91074_;
        if (!player.m_5833_()) {
            int totalMana = 0;
            int totalMaxMana = 0;
            boolean anyRequest = false;
            Inventory mainInv = player.m_150109_();
            Container accInv = BotaniaAPI.instance().getAccessoriesInventory((Player)player);
            int invSize = mainInv.m_6643_();
            int size = invSize + accInv.m_6643_();
            for (int i = 0; i < size; ++i) {
                boolean useAccessories = i >= invSize;
                Object inv = useAccessories ? accInv : mainInv;
                ItemStack stack = inv.m_8020_(i - (useAccessories ? invSize : 0));
                if (stack.m_41619_()) continue;
                anyRequest = anyRequest || stack.m_204117_(BotaniaTags.Items.MANA_USING_ITEMS);
            }
            List<ItemStack> items = ManaItemHandler.instance().getManaItems((Player)player);
            List<ItemStack> acc = ManaItemHandler.instance().getManaAccesories((Player)player);
            for (ItemStack stack : Iterables.concat(items, acc)) {
                ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                if (manaItem.isNoExport()) continue;
                totalMana += manaItem.getMana();
                totalMaxMana += manaItem.getMaxMana();
            }
            if (anyRequest) {
                HUDHandler.renderManaInvBar(gui, totalMana, totalMaxMana);
            }
        }
        profiler.m_6182_("itemsRemaining");
        ItemsRemainingRenderHandler.render(gui, partialTicks);
        profiler.m_7238_();
        profiler.m_7238_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderManaInvBar(GuiGraphics gui, int totalMana, int totalMaxMana) {
        Minecraft mc = Minecraft.m_91087_();
        int width = 182;
        int x = mc.m_91268_().m_85445_() / 2 - width / 2;
        int y = mc.m_91268_().m_85446_() - BotaniaConfig.client().manaBarHeight();
        width = totalMaxMana == 0 ? 0 : (int)((double)width * ((double)totalMana / (double)totalMaxMana));
        if (width == 0) {
            if (totalMana > 0) {
                width = 1;
            } else {
                return;
            }
        }
        int color = Mth.m_14169_((float)0.55f, (float)((float)Math.min(1.0, Math.sin((double)Util.m_137550_() / 200.0) * 0.5 + 1.0)), (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)(1.0f - (float)r / 255.0f));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, 0, 251, width, 5);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderPoolRecipeHUD(GuiGraphics gui, ManaPoolBlockEntity tile, ItemStack stack, boolean alternateRecipeHudPosition) {
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        profiler.m_6180_("poolRecipe");
        ManaInfusionRecipe recipe = tile.getMatchingRecipe(stack, tile.m_58904_().m_8055_(tile.m_58899_().m_7495_()));
        if (recipe != null) {
            int x = mc.m_91268_().m_85445_() / 2 - 11;
            int y = mc.m_91268_().m_85446_() / 2 + (alternateRecipeHudPosition ? -25 : 10);
            int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
            int v = mc.f_91074_.m_7755_().getString().equals("haighyorkie") && mc.f_91074_.m_6144_() ? 23 : 8;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, u, v, 22, 15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.m_280480_(stack, x - 20, y);
            ItemStack result = recipe.m_8043_(mc.f_91073_.m_9598_());
            gui.m_280480_(result, x + 26, y);
            gui.m_280370_(mc.f_91062_, result, x + 26, y);
            RenderSystem.disableBlend();
        }
        profiler.m_7238_();
    }

    private static void renderNearIndexDisplay(GuiGraphics gui) {
        Minecraft mc = Minecraft.m_91087_();
        String txt0 = I18n.m_118938_((String)"botaniamisc.nearIndex0", (Object[])new Object[0]);
        String txt1 = ChatFormatting.GRAY + I18n.m_118938_((String)"botaniamisc.nearIndex1", (Object[])new Object[0]);
        String txt2 = ChatFormatting.GRAY + I18n.m_118938_((String)"botaniamisc.nearIndex2", (Object[])new Object[0]);
        int l = Math.max(mc.f_91062_.m_92895_(txt0), Math.max(mc.f_91062_.m_92895_(txt1), mc.f_91062_.m_92895_(txt2))) + 20;
        int x = mc.m_91268_().m_85445_() - l - 20;
        int y = mc.m_91268_().m_85446_() - 60;
        RenderHelper.renderHUDBox(gui, x - 4, y - 4, x + l + 4, y + 35);
        gui.m_280480_(new ItemStack((ItemLike)BotaniaBlocks.corporeaIndex), x, y + 10);
        gui.m_280488_(mc.f_91062_, txt0, x + 20, y, 0xFFFFFF);
        gui.m_280488_(mc.f_91062_, txt1, x + 20, y + 14, 0xFFFFFF);
        gui.m_280488_(mc.f_91062_, txt2, x + 20, y + 24, 0xFFFFFF);
    }

    public static void drawSimpleManaHUD(GuiGraphics gui, int color, int mana, int maxMana, String name) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        Minecraft mc = Minecraft.m_91087_();
        int x = mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92895_(name) / 2;
        int y = mc.m_91268_().m_85446_() / 2 + 10;
        gui.m_280488_(mc.f_91062_, name, x, y, color);
        x = mc.m_91268_().m_85445_() / 2 - 51;
        HUDHandler.renderManaBar(gui, x, y += 10, color, 1.0f, mana, maxMana);
        RenderSystem.disableBlend();
    }

    public static void drawComplexManaHUD(int color, GuiGraphics gui, int mana, int maxMana, String name, ItemStack bindDisplay, boolean properlyBound) {
        PoseStack ms = gui.m_280168_();
        HUDHandler.drawSimpleManaHUD(gui, color, mana, maxMana, name);
        Minecraft mc = Minecraft.m_91087_();
        int x = mc.m_91268_().m_85445_() / 2 + 55;
        int y = mc.m_91268_().m_85446_() / 2 + 12;
        gui.m_280480_(bindDisplay, x, y);
        RenderSystem.disableDepthTest();
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, 200.0f);
        if (properlyBound) {
            gui.m_280488_(mc.f_91062_, "\u2714", x + 10, y + 9, 19456);
            gui.m_280488_(mc.f_91062_, "\u2714", x + 10, y + 8, 774669);
        } else {
            gui.m_280488_(mc.f_91062_, "\u2718", x + 10, y + 9, 0x4C0000);
            gui.m_280488_(mc.f_91062_, "\u2718", x + 10, y + 8, 13764621);
        }
        ms.m_85849_();
        RenderSystem.enableDepthTest();
    }

    public static void renderManaBar(GuiGraphics gui, int x, int y, int color, float alpha, int mana, int maxMana) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(gui, manaBar, x + 1, y + 1, 0, 5, 100, 3);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x + 1, y + 1, 0, 5, Math.min(100, manaPercentage), 3);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

