/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.AbstractHorseAccessor;
import vazkii.botania.mixin.RandomizableContainerBlockEntityAccessor;

public class SpectatorItem
extends BaubleItem {
    private static final int[] EMPTY_ENTITIES_ARRAY = new int[0];
    private static final long[] EMPTY_BLOCKPOS_ARRAY = new long[0];
    public static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
    public static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock";
    public static final int RANGE_ENTITIES = 24;
    public static final int RANGE_BLOCKS = 12;
    public static final int SCAN_INTERVAL_TICKS = 4;

    public SpectatorItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (living.m_9236_().f_46443_) {
            this.showScanResults(stack, player);
        } else if (living.f_19797_ % 4 == 0) {
            this.scanForItems(stack, player);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, LivingEntity entity) {
        ItemNBTHelper.removeEntry(stack, TAG_BLOCK_POSITIONS);
        ItemNBTHelper.removeEntry(stack, TAG_ENTITY_POSITIONS);
    }

    protected void showScanResults(ItemStack stack, Player player) {
        int[] entities;
        long[] blockPosLongs;
        if (player != Proxy.INSTANCE.getClientPlayer()) {
            return;
        }
        for (long blockPosLong : blockPosLongs = ItemNBTHelper.verifyType(stack, TAG_BLOCK_POSITIONS, LongArrayTag.class) ? ItemNBTHelper.getLongArray(stack, TAG_BLOCK_POSITIONS) : EMPTY_BLOCKPOS_ARRAY) {
            BlockPos pos = BlockPos.m_122022_((long)blockPosLong);
            float m = 0.02f;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), false);
            player.m_9236_().m_7106_((ParticleOptions)data, (double)((float)pos.m_123341_() + (float)Math.random()), (double)((float)pos.m_123342_() + (float)Math.random()), (double)((float)pos.m_123343_() + (float)Math.random()), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)));
        }
        for (int i : entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS)) {
            Entity e = player.m_9236_().m_6815_(i);
            if (e == null || !e.m_6084_() || !(Math.random() < 0.6)) continue;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), Math.random() < 0.6);
            player.m_9236_().m_7106_((ParticleOptions)data, e.m_20185_() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.m_20186_() + (double)e.m_20206_(), e.m_20189_() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), 0.0, (double)(0.05f + 0.03f * (float)Math.random()), 0.0);
        }
    }

    public void scanForItems(ItemStack stack, Player player) {
        ItemStack mainHandStack = player.m_21205_();
        ItemStack offHandStack = player.m_21206_();
        int[] entityIds = this.scanEntities(player, mainHandStack, offHandStack);
        ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, entityIds);
        long[] blockPositionLongs = this.scanBlockContainers(player, mainHandStack, offHandStack);
        ItemNBTHelper.setLongArray(stack, TAG_BLOCK_POSITIONS, blockPositionLongs);
    }

    private int[] scanEntities(Player player, ItemStack mainHandStack, ItemStack offHandStack) {
        boolean emptyHands;
        boolean bl = emptyHands = mainHandStack.m_41619_() && offHandStack.m_41619_();
        if (emptyHands && !player.m_6144_()) {
            return EMPTY_ENTITIES_ARRAY;
        }
        IntArrayList entityIds = new IntArrayList();
        List entities = player.m_9236_().m_45976_(Entity.class, new AABB(player.m_20183_()).m_82400_(24.0));
        for (Entity e : entities) {
            AbstractMinecartContainer minecart;
            Container inv;
            Allay allay;
            AbstractChestedHorse horse;
            if (e == player) continue;
            if (e instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)e;
                ItemStack entityStack = item.m_32055_();
                if (player.m_6144_() || this.equalStacks(entityStack, mainHandStack, offHandStack)) {
                    entityIds.add(item.m_19879_());
                }
            } else if (emptyHands) continue;
            if (e instanceof Player) {
                Player targetPlayer = (Player)e;
                if (this.scanInventory((Container)targetPlayer.m_150109_(), mainHandStack, offHandStack)) {
                    entityIds.add(targetPlayer.m_19879_());
                    continue;
                }
                Container baubleInventory = BotaniaAPI.instance().getAccessoriesInventory(targetPlayer);
                if (!this.scanInventory(baubleInventory, mainHandStack, offHandStack)) continue;
                entityIds.add(targetPlayer.m_19879_());
                continue;
            }
            if (e instanceof AbstractChestedHorse && (horse = (AbstractChestedHorse)e).m_30502_()) {
                if (!this.scanInventory((Container)((AbstractHorseAccessor)horse).getInventory(), mainHandStack, offHandStack)) continue;
                entityIds.add(horse.m_19879_());
                continue;
            }
            if (e instanceof Allay && (allay = (Allay)e).m_218389_()) {
                if (!this.equalStacks(allay.m_21205_(), mainHandStack, offHandStack)) continue;
                entityIds.add(allay.m_19879_());
                continue;
            }
            if (e instanceof Merchant) {
                Merchant villager = (Merchant)e;
                for (MerchantOffer offer : villager.m_6616_()) {
                    if (!this.equalStacks(offer.m_45352_(), mainHandStack, offHandStack) && !this.equalStacks(offer.m_45364_(), mainHandStack, offHandStack) && !this.equalStacks(offer.m_45368_(), mainHandStack, offHandStack)) continue;
                    entityIds.add(e.m_19879_());
                }
                continue;
            }
            if (!(e instanceof Container) || (inv = (Container)e) instanceof AbstractMinecartContainer && (minecart = (AbstractMinecartContainer)inv).m_214142_() != null || !this.scanInventory(inv, mainHandStack, offHandStack)) continue;
            entityIds.add(e.m_19879_());
        }
        entityIds.trim();
        return entityIds.elements();
    }

    private long[] scanBlockContainers(Player player, ItemStack mainHandStack, ItemStack offHandStack) {
        if (mainHandStack.m_41619_() && offHandStack.m_41619_()) {
            return EMPTY_BLOCKPOS_ARRAY;
        }
        LongArrayList blockPositions = new LongArrayList();
        BlockPos.m_121921_((AABB)new AABB(player.m_20183_()).m_82400_(12.0)).filter(pos -> this.scanBlock(player, (BlockPos)pos, mainHandStack, offHandStack)).forEach(pos -> blockPositions.add(pos.m_121878_()));
        blockPositions.trim();
        return blockPositions.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanBlock(Player player, BlockPos pos, ItemStack mainHandStack, ItemStack offHandStack) {
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (!(blockEntity instanceof Container)) return false;
        Container inv = (Container)blockEntity;
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity lootInv = (RandomizableContainerBlockEntity)blockEntity;
            if (((RandomizableContainerBlockEntityAccessor)lootInv).getLootTable() != null) return false;
        }
        if (!this.scanInventory(inv, mainHandStack, offHandStack)) return false;
        return true;
    }

    private boolean equalStacks(ItemStack testStack, ItemStack referenceStack1, ItemStack referenceStack2) {
        return !testStack.m_41619_() && (ItemStack.m_150942_((ItemStack)testStack, (ItemStack)referenceStack1) || ItemStack.m_150942_((ItemStack)testStack, (ItemStack)referenceStack2));
    }

    private boolean scanInventory(Container inv, ItemStack mainHandStack, ItemStack offHandStack) {
        for (int l = 0; l < inv.m_6643_(); ++l) {
            ItemStack inventoryStack = inv.m_8020_(l);
            if (inventoryStack == null || !this.equalStacks(inventoryStack, mainHandStack, offHandStack)) continue;
            return true;
        }
        return false;
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean armor = !living.m_6844_(EquipmentSlot.HEAD).m_41619_();
            bipedModel.f_102808_.m_104299_(ms);
            ms.m_85837_(-0.35, -0.2, armor ? 0.05 : 0.1);
            ms.m_85841_(0.75f, -0.75f, -0.75f);
            BakedModel model = MiscellaneousModels.INSTANCE.itemFinderGem;
            VertexConsumer buffer = buffers.m_6299_(Sheets.m_110790_());
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        }
    }
}

