/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class PlentifulMantleRodItem
extends Item {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_divining.png");
    static final int COST = 3000;

    public PlentifulMantleRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player p, @NotNull InteractionHand hand) {
        ItemStack stack = p.m_21120_(hand);
        if (ManaItemHandler.instance().requestManaExactForTool(stack, p, 3000, true)) {
            if (world.f_46443_) {
                int range = ManaItemHandler.instance().hasProficiency(p, stack) ? 20 : 15;
                long seedxor = world.f_46441_.m_188505_();
                PlentifulMantleRodItem.doHighlight(world, p.m_20183_(), range, seedxor);
            } else {
                world.m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), BotaniaSounds.divinationRod, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private static void doHighlight(Level world, BlockPos pos, int range, long seedxor) {
        for (BlockPos pos_ : BlockPos.m_121940_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range))) {
            BlockState state = world.m_8055_(pos_);
            Block block = state.m_60734_();
            if (!state.m_204336_(XplatAbstractions.INSTANCE.getOreTag())) continue;
            Random rand = new Random((long)BuiltInRegistries.f_256975_.m_7981_((Object)block).hashCode() ^ seedxor);
            WispParticleData data = WispParticleData.wisp(0.25f, rand.nextFloat(), rand.nextFloat(), rand.nextFloat(), 8.0f, false);
            world.m_6493_((ParticleOptions)data, true, (double)((float)pos_.m_123341_() + world.f_46441_.m_188501_()), (double)((float)pos_.m_123342_() + world.f_46441_.m_188501_()), (double)((float)pos_.m_123343_() + world.f_46441_.m_188501_()), 0.0, 0.0, 0.0);
        }
    }

    public static class AvatarBehavior
    implements AvatarWieldable {
        @Override
        public void onAvatarUpdate(Avatar tile) {
            BlockEntity te = (BlockEntity)tile;
            Level world = te.m_58904_();
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, te.m_58899_(), te.m_58900_(), te, null);
            if (receiver.getCurrentMana() >= 3000 && tile.getElapsedFunctionalTicks() % 200 == 0 && tile.isEnabled()) {
                PlentifulMantleRodItem.doHighlight(world, te.m_58899_(), 18, te.m_58899_().hashCode());
                receiver.receiveMana(-3000);
            }
        }

        @Override
        public ResourceLocation getOverlayResource(Avatar tile) {
            return avatarOverlay;
        }
    }
}

