/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.common.advancements.AlfheimPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfheimPortalTrigger;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.advancements.GaiaGuardianNoArmorTrigger;
import vazkii.botania.common.advancements.LokiPlaceTrigger;
import vazkii.botania.common.advancements.ManaBlasterTrigger;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AdvancementProvider {
    public static net.minecraft.data.advancements.AdvancementProvider create(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        return new net.minecraft.data.advancements.AdvancementProvider(packOutput, lookupProvider, List.of(new BotaniaStoryAdvancements(), new BotaniaChallengeAdvancements()));
    }

    private static Advancement relicBindAdvancement(Consumer<Advancement> consumer, Advancement parent, Item relicItem, String titleKey, String criterionName) {
        String id = AdvancementProvider.challengeId(BuiltInRegistries.f_257033_.m_7981_((Object)relicItem).m_135815_());
        return Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)relicItem, titleKey, FrameType.CHALLENGE)).m_138398_(parent).m_138386_(criterionName, (CriterionTriggerInstance)new RelicBindTrigger.Instance(ContextAwarePredicate.f_285567_, ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{relicItem}).m_45077_())).m_138389_(consumer, id);
    }

    protected static InventoryChangeTrigger.TriggerInstance onPickup(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()});
    }

    protected static InventoryChangeTrigger.TriggerInstance onPickup(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{AdvancementProvider.matchItems(items)});
    }

    protected static ItemPredicate matchItems(ItemLike ... items) {
        return ItemPredicate.Builder.m_45068_().m_151445_(items).m_45077_();
    }

    protected static DisplayInfo simple(ItemLike icon, String name, FrameType frameType) {
        String expandedName = "advancement.botania:" + name;
        return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)Component.m_237115_((String)expandedName), (Component)Component.m_237115_((String)(expandedName + ".desc")), null, frameType, true, true, false);
    }

    protected static DisplayInfo hidden(ItemLike icon, String name, FrameType frameType) {
        String expandedName = "advancement.botania:" + name;
        return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)Component.m_237115_((String)expandedName), (Component)Component.m_237115_((String)(expandedName + ".desc")), null, frameType, true, true, true);
    }

    protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
        return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)Component.m_237115_((String)titleKey), (Component)Component.m_237115_((String)descKey), background, FrameType.TASK, false, false, false);
    }

    private static String mainId(String name) {
        return ResourceLocationHelper.prefix("main/" + name).toString();
    }

    private static String challengeId(String name) {
        return ResourceLocationHelper.prefix("challenge/" + name).toString();
    }

    public static class BotaniaStoryAdvancements
    implements AdvancementSubProvider {
        public void m_245571_(HolderLookup.Provider lookup, Consumer<Advancement> consumer) {
            CompoundTag elvenLexiconUnlock = new CompoundTag();
            elvenLexiconUnlock.m_128379_("botania:elven_unlock", true);
            InventoryChangeTrigger.TriggerInstance elvenLexicon = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{BotaniaItems.lexicon}).m_45075_(elvenLexiconUnlock).m_45077_()});
            Advancement root = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.rootDisplay((ItemLike)BotaniaItems.lexicon, "itemGroup.botania.botania", "botania.desc", ResourceLocationHelper.prefix("textures/block/livingwood_log.png"))).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.mainId("root"));
            Advancement flowerPickup = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.pinkFlower, "flowerPickup", FrameType.TASK)).m_138398_(root).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).m_138386_("double_flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.DOUBLE_MYSTICAL_FLOWERS)).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("flower_pickup"));
            Advancement manaPoolPickup = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.manaPool, "manaPoolPickup", FrameType.TASK)).m_138398_(flowerPickup).m_138386_("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool})).m_138389_(consumer, AdvancementProvider.mainId("mana_pool_pickup"));
            Advancement runePickup = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.runeAltar, "runePickup", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("rune", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.RUNES)).m_138389_(consumer, AdvancementProvider.mainId("rune_pickup"));
            Advancement terrasteelPickup = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.terrasteel, "terrasteelPickup", FrameType.TASK)).m_138398_(runePickup).m_138386_("terrasteel", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terrasteel})).m_138389_(consumer, AdvancementProvider.mainId("terrasteel_pickup"));
            Advancement elfPortalOpen = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.alfPortal, "elfPortalOpen", FrameType.TASK)).m_138398_(terrasteelPickup).m_138386_("portal", (CriterionTriggerInstance)new AlfheimPortalTrigger.Instance(ContextAwarePredicate.f_285567_, ItemPredicate.f_45028_, LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.mainId("elf_portal_open"));
            Advancement gaiaGuardianKill = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.gaiaHead, "gaiaGuardianKill", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("guardian", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(BotaniaEntities.DOPPLEGANGER))).m_138389_(consumer, AdvancementProvider.mainId("gaia_guardian_kill"));
            Advancement enderAirMake = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.enderAirBottle, "enderAirMake", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("air", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.enderAirBottle})).m_138389_(consumer, AdvancementProvider.mainId("ender_air_make"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.lexicon, "lexiconUse", FrameType.TASK)).m_138398_(root).m_138386_("use_lexicon", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(ContextAwarePredicate.f_285567_, ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{BotaniaItems.lexicon}).m_45077_(), LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.mainId("lexicon_use"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.cacophonium, "cacophoniumCraft", FrameType.TASK)).m_138398_(root).m_138386_("cacophonium", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.cacophonium})).m_138389_(consumer, AdvancementProvider.mainId("cacophonium_craft"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.endoflame, "generatingFlower", FrameType.TASK)).m_138398_(flowerPickup).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.GENERATING_SPECIAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.mainId("generating_flower"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.enchanter, "enchanterMake", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.mainId("enchanter_make"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.bellethorn, "functionalFlower", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.FUNCTIONAL_SPECIAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.mainId("functional_flower"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.poolMinecart, "manaCartCraft", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("poolcart", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.poolMinecart})).m_138389_(consumer, AdvancementProvider.mainId("mana_cart_craft"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.manaweaveCloth, "manaweaveArmorCraft", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("head", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.manaweaveHelm, BotaniaItems.manaweaveChest, BotaniaItems.manaweaveLegs, BotaniaItems.manaweaveBoots})).m_138389_(consumer, AdvancementProvider.mainId("manaweave_armor_craft"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.spark, "sparkCraft", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("spark", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.spark})).m_138389_(consumer, AdvancementProvider.mainId("spark_craft"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.manaCookie, "manaCookieEat", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("cookie", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)BotaniaItems.manaCookie)).m_138389_(consumer, AdvancementProvider.mainId("mana_cookie_eat"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.craftingHalo, "craftingHaloCraft", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("pool", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.craftingHalo})).m_138389_(consumer, AdvancementProvider.mainId("crafting_halo_craft"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.manaRing, "baubleWear", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.mainId("bauble_wear"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.tinyPotato, "tinyPotatoPet", FrameType.TASK)).m_138398_(manaPoolPickup).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.mainId("tiny_potato_pet"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.manaGun, "manaBlasterShoot", FrameType.TASK)).m_138398_(runePickup).m_138386_("shoot", (CriterionTriggerInstance)new ManaBlasterTrigger.Instance(ContextAwarePredicate.f_285567_, ItemPredicate.f_45028_, EntityPredicate.f_36550_)).m_138389_(consumer, AdvancementProvider.mainId("mana_blaster_shoot"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.pollidisiac, "pollidisiacPickup", FrameType.TASK)).m_138398_(runePickup).m_138386_("pollidisiac", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.pollidisiac})).m_138389_(consumer, AdvancementProvider.mainId("pollidisiac_pickup"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.dirtRod, "dirtRodCraft", FrameType.TASK)).m_138398_(runePickup).m_138386_("dirtrod", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.dirtRod})).m_138389_(consumer, AdvancementProvider.mainId("dirt_rod_craft"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.brewery, "brewPickup", FrameType.TASK)).m_138398_(runePickup).m_138386_("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.brewFlask, BotaniaItems.brewVial})).m_138389_(consumer, AdvancementProvider.mainId("brew_pickup"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.terraSword, "terrasteelWeaponCraft", FrameType.TASK)).m_138398_(terrasteelPickup).m_138386_("terrablade", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terraSword, BotaniaItems.thornChakram})).m_138389_(consumer, AdvancementProvider.mainId("terrasteel_weapon_craft"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.heiseiDream, "heiseiDreamPickup", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("heisei_dream", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.heiseiDream})).m_138389_(consumer, AdvancementProvider.mainId("heisei_dream_pickup"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.kekimurus, "kekimurusPickup", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("kekimurus", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.kekimurus})).m_138389_(consumer, AdvancementProvider.mainId("kekimurus_pickup"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.bubbell, "bubbellPickup", FrameType.TASK)).m_138398_(elfPortalOpen).m_138386_("bubbell", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.bubbell})).m_138389_(consumer, AdvancementProvider.mainId("bubbell_pickup"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.spawnerMover, "spawnerMoverUse", FrameType.TASK)).m_138398_(gaiaGuardianKill).m_138386_("use_spawner_mover", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(ContextAwarePredicate.f_285567_, ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{BotaniaItems.spawnerMover}).m_45077_(), LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.mainId("spawner_mover_use"));
            DisplayInfo tiaraWings = AdvancementProvider.simple((ItemLike)BotaniaItems.flightTiara, "tiaraWings", FrameType.TASK);
            tiaraWings.m_14990_().m_41784_().m_128405_("variant", 1);
            InventoryChangeTrigger.TriggerInstance[] variants = (InventoryChangeTrigger.TriggerInstance[])IntStream.range(1, 9).mapToObj(i -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("variant", i);
                return tag;
            }).map(nbt -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{BotaniaItems.flightTiara}).m_45075_(nbt).m_45077_()).map(xva$0 -> InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{xva$0})).toArray(InventoryChangeTrigger.TriggerInstance[]::new);
            Advancement.Builder builder = Advancement.Builder.m_138353_().m_138358_(tiaraWings).m_138398_(gaiaGuardianKill).m_138360_(RequirementsStrategy.f_15979_);
            for (int i2 = 0; i2 < variants.length; ++i2) {
                InventoryChangeTrigger.TriggerInstance variant = variants[i2];
                builder.m_138386_("tiara_" + (i2 + 1), (CriterionTriggerInstance)variant);
            }
            builder.m_138389_(consumer, AdvancementProvider.mainId("tiara_wings"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.dandelifeon, "dandelifeonPickup", FrameType.TASK)).m_138398_(gaiaGuardianKill).m_138386_("dandelifeon", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.dandelifeon})).m_138389_(consumer, AdvancementProvider.mainId("dandelifeon_pickup"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.manaBomb, "manaBombIgnite", FrameType.TASK)).m_138398_(gaiaGuardianKill).m_138386_("bomb", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaBomb})).m_138389_(consumer, AdvancementProvider.mainId("mana_bomb_ignite"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.lightRelayDefault, "luminizerRide", FrameType.TASK)).m_138398_(enderAirMake).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.mainId("luminizer_ride"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.corporeaCrystalCube, "corporeaCraft", FrameType.TASK)).m_138398_(enderAirMake).m_138386_("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.corporeaCrystalCube, BotaniaBlocks.corporeaFunnel, BotaniaBlocks.corporeaIndex, BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaRetainer})).m_138389_(consumer, AdvancementProvider.mainId("corporea_craft"));
            Advancement.Builder.m_138353_().m_138398_(root).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("flower_pickup_lexicon"));
            Advancement.Builder.m_138353_().m_138398_(flowerPickup).m_138386_("apothecary", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.defaultAltar})).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("apothecary_pickup"));
            Advancement.Builder.m_138353_().m_138398_(flowerPickup).m_138386_("daisy", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.pureDaisy})).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("pure_daisy_pickup"));
            Advancement.Builder.m_138353_().m_138398_(root).m_138386_("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool})).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("mana_pool_pickup_lexicon"));
            Advancement.Builder.m_138353_().m_138398_(flowerPickup).m_138386_("altar", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.runeAltar})).m_138386_("rune", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.RUNES)).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("runic_altar_pickup"));
            Advancement.Builder.m_138353_().m_138398_(flowerPickup).m_138386_("terrasteel", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terrasteel})).m_138386_("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.mainId("terrasteel_pickup_lexicon"));
            Advancement.Builder.m_138353_().m_138398_(elfPortalOpen).m_138386_("lexicon", (CriterionTriggerInstance)elvenLexicon).m_138389_(consumer, AdvancementProvider.mainId("elf_lexicon_pickup"));
        }
    }

    public static class BotaniaChallengeAdvancements
    implements AdvancementSubProvider {
        public void m_245571_(HolderLookup.Provider lookup, Consumer<Advancement> consumer) {
            Advancement root = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.rootDisplay((ItemLike)BotaniaItems.dice, "advancement.botania_challenge", "advancement.botania_challenge.desc", ResourceLocationHelper.prefix("textures/block/livingrock_bricks.png"))).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).m_138389_(consumer, AdvancementProvider.challengeId("root"));
            CompoundTag hardmodeNbt = new CompoundTag();
            hardmodeNbt.m_128379_("hardMode", true);
            Advancement hardMode = Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.lifeEssence, "gaiaGuardianHardmode", FrameType.CHALLENGE)).m_138398_(root).m_138386_("guardian", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(BotaniaEntities.DOPPLEGANGER).m_36654_(new NbtPredicate(hardmodeNbt)).m_36662_())).m_138389_(consumer, AdvancementProvider.challengeId("gaia_guardian_hardmode"));
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.infiniteFruit, "infiniteFruit", "fruit");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.kingKey, "kingKey", "key");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.flugelEye, "flugelEye", "eye");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.thorRing, "thorRing", "ring");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.odinRing, "odinRing", "ring");
            Advancement lokiRing = AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.lokiRing, "lokiRing", "ring");
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.lokiRing, "lokiRingMany", FrameType.CHALLENGE)).m_138398_(lokiRing).m_138386_("place_blocks", (CriterionTriggerInstance)new LokiPlaceTrigger.Instance(ContextAwarePredicate.f_285567_, EntityPredicate.f_36550_, ItemPredicate.f_45028_, MinMaxBounds.Ints.m_55386_((int)255))).m_138389_(consumer, AdvancementProvider.challengeId("loki_ring_many"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.pinkinator, "pinkinator", FrameType.CHALLENGE)).m_138398_(hardMode).m_138386_("use_pinkinator", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(ContextAwarePredicate.f_285567_, AdvancementProvider.matchItems(new ItemLike[]{BotaniaItems.pinkinator}), LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.challengeId("pinkinator"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)Blocks.f_50316_, "gaiaGuardianNoArmor", FrameType.CHALLENGE)).m_138398_(root).m_138386_("no_armor", (CriterionTriggerInstance)new GaiaGuardianNoArmorTrigger.Instance(ContextAwarePredicate.f_285567_, EntityPredicate.f_36550_, DamageSourcePredicate.f_25420_)).m_138389_(consumer, AdvancementProvider.challengeId("gaia_guardian_no_armor"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.hidden((ItemLike)BotaniaBlocks.motifDaybloom, "old_flower_pickup", FrameType.CHALLENGE)).m_138398_(root).m_138386_("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.motifDaybloom, BotaniaBlocks.motifNightshade})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, AdvancementProvider.challengeId("old_flower_pickup"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.corporeaIndex, "superCorporeaRequest", FrameType.CHALLENGE)).m_138398_(root).m_138386_("big_request", (CriterionTriggerInstance)new CorporeaRequestTrigger.Instance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.m_55386_((int)65536), LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.challengeId("super_corporea_request"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.terraPick, "rankSSPick", FrameType.CHALLENGE)).m_138398_(root).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.challengeId("rank_ss_pick"));
            CompoundTag level20Shard = new CompoundTag();
            level20Shard.m_128405_("level", 19);
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaItems.laputaShard, "l20ShardUse", FrameType.CHALLENGE)).m_138398_(root).m_138386_("use_l20_shard", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{BotaniaItems.laputaShard}).m_45075_(level20Shard).m_45077_()})).m_138389_(consumer, AdvancementProvider.challengeId("l20_shard_use"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.hidden((ItemLike)Items.f_42406_, "alfPortalBread", FrameType.CHALLENGE)).m_138398_(root).m_138386_("bread", (CriterionTriggerInstance)new AlfheimPortalBreadTrigger.Instance(ContextAwarePredicate.f_285567_, LocationPredicate.f_52592_)).m_138389_(consumer, AdvancementProvider.challengeId("alf_portal_bread"));
            Advancement.Builder.m_138353_().m_138358_(AdvancementProvider.simple((ItemLike)BotaniaBlocks.tinyPotato, "tinyPotatoBirthday", FrameType.CHALLENGE)).m_138398_(root).m_138386_("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, AdvancementProvider.challengeId("tiny_potato_birthday"));
        }
    }
}

