/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.forge.inventory.power;

import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ForgePolyEnergyWrapper
implements IPolyEnergyStorageItem {
    private final IEnergyStorage storage;
    private ItemStack container = ItemStack.f_41583_;

    public ForgePolyEnergyWrapper(IEnergyStorage storage) {
        this.storage = storage;
    }

    public ForgePolyEnergyWrapper(IEnergyStorage storage, ItemStack container) {
        this.storage = storage;
        this.container = container;
    }

    @Override
    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        return this.storage.receiveEnergy((int)Math.min(maxReceive, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        return this.storage.extractEnergy((int)Math.min(maxExtract, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    @Override
    public long getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canExtract() {
        return this.storage.canExtract();
    }

    @Override
    public boolean canReceive() {
        return this.storage.canReceive();
    }

    @Override
    public long modifyEnergyStored(long amount) {
        if ((amount = Math.min(Math.max(amount, Integer.MIN_VALUE), Integer.MAX_VALUE)) > 0L) {
            return this.receiveEnergy((int)amount, false);
        }
        return this.extractEnergy((int)(-amount), false);
    }
}

