/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render.alchemyarray;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableQuadrilateral;
import wayoftime.bloodmagic.client.render.alchemyarray.AlchemyArrayRenderer;
import wayoftime.bloodmagic.common.tile.TileAlchemyArray;

public class BindingAlchemyCircleRenderer
extends AlchemyArrayRenderer {
    public static final int numberOfSweeps = 5;
    public static final int startTime = 50;
    public static final int sweepTime = 40;
    public static final int inwardRotationTime = 50;
    public static final float arcLength = (float)Math.sqrt(8.0 - 8.0 * Math.cos(2.5132741228718345));
    public static final float theta2 = 0.31415927f;
    public static final int endTime = 300;
    public final ResourceLocation[] arraysResources = new ResourceLocation[5];
    public float offsetFromFace = -0.9f;

    public BindingAlchemyCircleRenderer() {
        super(new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindingarray.png"));
        this.arraysResources[0] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
        this.arraysResources[1] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
        this.arraysResources[2] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
        this.arraysResources[3] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
        this.arraysResources[4] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
    }

    public float getRotation(int circle, float craftTime) {
        float offset = 2.0f;
        if (circle == -1 && craftTime >= offset) {
            return (craftTime - offset) * 360.0f * 2.0f / 5.0f / 40.0f;
        }
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.5);
            return modifier * 0.5f;
        }
        return 0.0f;
    }

    public float getSecondaryRotation(int circle, float craftTime) {
        float offset = 50.0f;
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.7);
            return modifier * 0.5f;
        }
        return 0.0f;
    }

    public float getVerticalOffset(int circle, float craftTime) {
        if (circle >= 0 && circle <= 4) {
            if (craftTime >= 5.0f) {
                if (craftTime <= 40.0f) {
                    return (float)(0.4 * Math.pow((craftTime - 5.0f) / 35.0f, 3.0));
                }
                return 0.4f;
            }
            return 0.0f;
        }
        if (craftTime >= 5.0f) {
            if (craftTime <= 40.0f) {
                return (float)(0.4 * Math.pow((craftTime - 5.0f) / 35.0f, 3.0));
            }
            return 0.4f;
        }
        return 0.0f;
    }

    public float getInwardRotation(int circle, float craftTime) {
        float offset = 250.0f;
        if (craftTime >= offset) {
            if (craftTime <= offset + 50.0f) {
                return 1.8f * (craftTime - offset);
            }
            return 90.0f;
        }
        return 0.0f;
    }

    @Override
    public void renderAt(TileAlchemyArray tileArray, double x, double y, double z, float craftTime, PoseStack matrixStack, MultiBufferSource renderer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        float rot = this.getRotation(-1, craftTime);
        float secondaryRot = this.getSecondaryRotation(craftTime);
        float size = 3.0f;
        Direction dirRotation = tileArray.getRotation();
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, this.getVerticalOffset(craftTime), 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-dirRotation.m_122435_()));
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(rot));
        VertexConsumer twoDBuffer = renderer.m_6299_(RenderType.m_110473_((ResourceLocation)this.arrayResource));
        BloodMagicRenderer.Model2D arrayModel = new BloodMagicRenderer.Model2D();
        arrayModel.minX = -0.5;
        arrayModel.maxX = 0.5;
        arrayModel.minY = -0.5;
        arrayModel.maxY = 0.5;
        arrayModel.resource = this.arrayResource;
        matrixStack.m_85841_(size, size, size);
        RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, -1, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
        for (int i = 0; i < 5; ++i) {
            matrixStack.m_85836_();
            float newSize = 1.0f;
            float distance = BindingAlchemyCircleRenderer.getDistanceOfCircle(i, craftTime);
            float angle = BindingAlchemyCircleRenderer.getAngleOfCircle(i, craftTime);
            float rotation = this.getRotation(i, craftTime);
            matrixStack.m_85837_((double)distance * Math.sin(angle), (double)this.getVerticalOffset(i, craftTime), (double)(-distance) * Math.cos(angle));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)(i * 360 / 5)));
            matrixStack.m_252781_(Axis.f_252393_.m_252977_(this.getInwardRotation(i, craftTime)));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
            twoDBuffer = renderer.m_6299_(RenderType.m_110473_((ResourceLocation)this.arraysResources[i]));
            arrayModel.resource = this.arraysResources[i];
            matrixStack.m_85841_(newSize, newSize, newSize);
            RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, -1, combinedLightIn, combinedOverlayIn);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    public static float getAngleOfCircle(int circle, float craftTime) {
        if (circle >= 0 && circle <= 4) {
            float originalAngle = (float)((double)(circle * 2) * Math.PI / 5.0);
            double sweep = (craftTime - 50.0f) / 40.0f;
            if (sweep >= 0.0 && sweep < 5.0) {
                float offset = (int)sweep * 40 + 50;
                originalAngle = (float)((double)originalAngle + (2.5132741228718345 * (double)((int)sweep) + (double)BindingAlchemyCircleRenderer.getAngle(craftTime - offset, (int)sweep)));
            } else if (sweep >= 5.0) {
                originalAngle = (float)((double)originalAngle + (Math.PI * 4 + (double)((craftTime - 200.0f - 50.0f) * 2.0f) * Math.PI * 2.0 / 5.0 / 40.0));
            }
            return originalAngle;
        }
        return 0.0f;
    }

    public static float getAngle(float craftTime, int sweep) {
        float rDP = craftTime / 40.0f * arcLength;
        float rEnd = (float)Math.sqrt((double)(rDP * rDP + 4.0f) - (double)(2.0f * rDP * 2.0f) * Math.cos(0.3141592741012573));
        return (float)Math.acos((4.0f + rEnd * rEnd - rDP * rDP) / (2.0f * rEnd * 2.0f));
    }

    public static float getDistanceOfCircle(int circle, float craftTime) {
        double sweep = (craftTime - 50.0f) / 40.0f;
        if (sweep >= 0.0 && sweep < 5.0) {
            float offset = (int)sweep * 40 + 50;
            float angle = BindingAlchemyCircleRenderer.getAngle(craftTime - offset, (int)sweep);
            float thetaPrime = (float)(2.827433379488536 - (double)angle);
            return (float)(2.0 * Math.sin(0.3141592741012573) / Math.sin(thetaPrime));
        }
        if (sweep >= 5.0 && craftTime < 300.0f) {
            return 2.0f - 2.0f * (craftTime - 50.0f - 200.0f) / 50.0f;
        }
        if (craftTime >= 300.0f) {
            return 0.0f;
        }
        return 2.0f;
    }
}

