/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.alchemyarray;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import wayoftime.bloodmagic.client.render.alchemyarray.BindingAlchemyCircleRenderer;
import wayoftime.bloodmagic.common.alchemyarray.AlchemyArrayEffect;
import wayoftime.bloodmagic.common.alchemyarray.AlchemyArrayEffectCrafting;
import wayoftime.bloodmagic.common.tile.TileAlchemyArray;

public class AlchemyArrayEffectBinding
extends AlchemyArrayEffectCrafting {
    public AlchemyArrayEffectBinding(ItemStack outputStack, int tickLimit) {
        super(outputStack, tickLimit);
    }

    public AlchemyArrayEffectBinding(ItemStack outputStack) {
        this(outputStack, 300);
    }

    @Override
    public boolean update(TileAlchemyArray tile, int ticksActive) {
        if (tile.m_58904_().f_46443_) {
            return false;
        }
        if (ticksActive >= 50 && ticksActive <= 250) {
            this.spawnLightningOnCircle(tile.m_58904_(), tile.m_58899_(), ticksActive);
        }
        if (ticksActive >= this.tickLimit) {
            BlockPos pos = tile.m_58899_();
            ItemStack output = this.outputStack.m_41777_();
            ItemEntity outputEntity = new ItemEntity(tile.m_58904_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, output);
            tile.m_58904_().m_7967_((Entity)outputEntity);
            return true;
        }
        return false;
    }

    public void spawnLightningOnCircle(Level world, BlockPos pos, int ticksActive) {
        if (ticksActive % 50 == 0) {
            int circle = ticksActive / 50 - 1;
            float distance = BindingAlchemyCircleRenderer.getDistanceOfCircle(circle, ticksActive);
            float angle = BindingAlchemyCircleRenderer.getAngleOfCircle(circle, ticksActive);
            double dispX = (double)distance * Math.sin(angle);
            double dispZ = (double)(-distance) * Math.cos(angle);
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            lightningboltentity.m_6034_((double)pos.m_123341_() + dispX, (double)pos.m_123342_(), (double)pos.m_123343_() + dispZ);
            lightningboltentity.m_20874_(true);
            world.m_7967_((Entity)lightningboltentity);
        }
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectBinding(this.outputStack, this.tickLimit);
    }
}

