/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import wayoftime.bloodmagic.api.compat.IAltarReader;
import wayoftime.bloodmagic.common.block.BloodstoneBlock;
import wayoftime.bloodmagic.common.tile.TileAltar;
import wayoftime.bloodmagic.util.Utils;

public class BlockAltar
extends Block
implements EntityBlock {
    protected static final VoxelShape BODY = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public boolean isRedstoneActive = false;

    public BlockAltar() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 5.0f).m_60999_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BODY;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileAltar(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TileAltar::tick;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        this.isRedstoneActive = false;
        TileAltar altar = (TileAltar)world.m_7702_(pos);
        Block blockdown = world.m_8055_(pos.m_7495_()).m_60734_();
        int redstoneMode = 0;
        if (blockdown instanceof BloodstoneBlock) {
            redstoneMode = 1;
        }
        if (blockdown instanceof RedstoneLampBlock) {
            redstoneMode = 2;
            this.isRedstoneActive = true;
        }
        return altar.getAnalogSignalStrength(redstoneMode);
    }

    public boolean m_7899_(BlockState iBlockState) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockReader, BlockPos pos, Direction dir) {
        boolean isOutputOn = false;
        BlockEntity tileentity = blockReader.m_7702_(pos);
        if (tileentity instanceof TileAltar) {
            TileAltar altar = (TileAltar)tileentity;
            isOutputOn = altar.getOutputState();
        }
        int OUTPUT_POWER_WHEN_ON = 15;
        return isOutputOn ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockReader, BlockPos pos, Direction dir) {
        return 0;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        TileAltar altar = (TileAltar)world.m_7702_(pos);
        if (altar == null || player.m_6144_()) {
            return InteractionResult.FAIL;
        }
        ItemStack playerItem = player.m_21120_(hand);
        if (playerItem.m_41720_() instanceof IAltarReader) {
            playerItem.m_41720_().m_7203_(world, player, hand);
            return InteractionResult.SUCCESS;
        }
        if (Utils.insertItemToTile(altar, player)) {
            altar.startCycle();
        } else {
            altar.setActive();
        }
        world.m_7260_(pos, state, state, 3);
        return InteractionResult.SUCCESS;
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        TileAltar altar = (TileAltar)world.m_7702_(blockPos);
        if (altar != null) {
            altar.dropItems();
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof TileAltar) {
                ((TileAltar)tileentity).dropItems();
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }
}

