/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;

public class BlockNetherrackSoil
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public BlockNetherrackSoil(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7494_());
        return !blockstate.m_280296_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? Blocks.f_50134_.m_49966_() : super.m_5573_(context);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            BlockNetherrackSoil.turnToDirt(state, (Level)worldIn, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.m_61143_((Property)MOISTURE);
        if (!BlockNetherrackSoil.hasLifeEssence((LevelReader)worldIn, pos) && !worldIn.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops((BlockGetter)worldIn, pos)) {
                BlockNetherrackSoil.turnToDirt(state, (Level)worldIn, pos);
            }
        } else if (i < 7) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public static void turnToDirt(BlockState state, Level worldIn, BlockPos pos) {
        worldIn.m_46597_(pos, BlockNetherrackSoil.m_49897_((BlockState)state, (BlockState)Blocks.f_50134_.m_49966_(), (LevelAccessor)worldIn, (BlockPos)pos));
    }

    private boolean hasCrops(BlockGetter worldIn, BlockPos pos) {
        BlockState plant = worldIn.m_8055_(pos.m_7494_());
        BlockState state = worldIn.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(worldIn, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean hasLifeEssence(LevelReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!worldIn.m_6425_(blockpos).m_205070_(BloodMagicTags.LIFE_ESSENCE)) continue;
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MOISTURE});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }
}

