/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.container.item;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.inventory.InventoryHolding;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;

public class ContainerHolding
extends AbstractContainerMenu {
    public final InventoryHolding inventoryHolding;
    private final int PLAYER_INVENTORY_ROWS = 3;
    private final int PLAYER_INVENTORY_COLUMNS = 9;
    private final Player player;

    public ContainerHolding(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory.f_35978_, playerInventory, new InventoryHolding(extraData.m_130267_()));
    }

    public ContainerHolding(int windowId, Player player, Inventory playerInventory, InventoryHolding inventoryHolding) {
        super((MenuType)BloodMagicBlocks.HOLDING_CONTAINER.get(), windowId);
        this.player = player;
        this.inventoryHolding = inventoryHolding;
        int currentSlotHeldIn = player.m_150109_().f_35977_;
        this.setup(playerInventory, currentSlotHeldIn);
    }

    public void setup(Inventory inventory, int currentSlotHeldIn) {
        for (int columnIndex = 0; columnIndex < 5; ++columnIndex) {
            this.m_38897_(new SlotHolding(this, this.inventoryHolding, this.player, columnIndex, 8 + columnIndex * 36, 17));
        }
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < 9; ++columnIndex) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), columnIndex + rowIndex * 9 + 9, 8 + columnIndex * 18, 41 + rowIndex * 18));
            }
        }
        for (int actionBarIndex = 0; actionBarIndex < 9; ++actionBarIndex) {
            if (actionBarIndex == currentSlotHeldIn) {
                this.m_38897_(new SlotDisabled((Container)this.player.m_150109_(), actionBarIndex, 8 + actionBarIndex * 18, 99));
                continue;
            }
            this.m_38897_(new Slot((Container)this.player.m_150109_(), actionBarIndex, 8 + actionBarIndex * 18, 99));
        }
    }

    public boolean m_6875_(Player entityPlayer) {
        return true;
    }

    public void m_6877_(Player entityPlayer) {
        super.m_6877_(entityPlayer);
        if (!entityPlayer.m_20193_().f_46443_) {
            this.saveInventory(entityPlayer);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.player.m_20193_().f_46443_) {
            this.saveInventory(this.player);
        }
    }

    public ItemStack m_7648_(Player entityPlayer, int slotIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slotObject = (Slot)this.f_38839_.get(slotIndex);
        int slotCount = this.f_38839_.size();
        if (slotObject != null && slotObject.m_6657_()) {
            ItemStack stackInSlot = slotObject.m_7993_();
            stack = stackInSlot.m_41777_();
            if (stack.m_41720_() instanceof ISigil ? (slotIndex < 5 ? !this.m_38903_(stackInSlot, 5, slotCount, false) : !this.m_38903_(stackInSlot, 0, 5, false)) : stack.m_41720_() instanceof ItemSigilHolding && (slotIndex < 32 ? !this.m_38903_(stackInSlot, 32, this.f_38839_.size(), false) : !this.m_38903_(stackInSlot, 5, 32, false))) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slotObject.m_5852_(ItemStack.f_41583_);
            } else {
                slotObject.m_6654_();
            }
            if (stackInSlot.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slotObject.m_142406_(this.player, stackInSlot);
        }
        return stack;
    }

    public void saveInventory(Player entityPlayer) {
        this.inventoryHolding.onGuiSaved(entityPlayer);
    }

    private class SlotHolding
    extends Slot {
        private final Player player;
        private ContainerHolding containerHolding;

        public SlotHolding(ContainerHolding containerHolding2, Container inventory, Player player, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.player = player;
            this.containerHolding = containerHolding2;
        }

        public void m_6654_() {
            super.m_6654_();
            if (EffectiveSide.get().isServer()) {
                this.containerHolding.saveInventory(this.player);
            }
        }

        public boolean m_5857_(ItemStack itemStack) {
            return itemStack.m_41720_() instanceof ISigil && !(itemStack.m_41720_() instanceof ItemSigilHolding);
        }
    }

    private class SlotDisabled
    extends Slot {
        public SlotDisabled(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }
}

