/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class ARCPotionRecipeBuilder
extends BloodMagicRecipeBuilder<ARCPotionRecipeBuilder> {
    private final Ingredient input;
    private int inputSize;
    private final Ingredient arcTool;
    private final FluidStackIngredient inputFluid;
    private final ItemStack output;
    private final FluidStack outputFluid;
    private final List<Pair<ItemStack, Pair<Double, Double>>> addedItems = new ArrayList<Pair<ItemStack, Pair<Double, Double>>>();
    private final boolean consumeIngredient;
    private double additionalMainOutputChance;

    protected ARCPotionRecipeBuilder(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid, boolean consumeIngredient, double additionalMainOutputChance) {
        super(ARCPotionRecipeBuilder.bmSerializer("arc_potion"));
        this.input = input;
        this.arcTool = arcTool;
        this.inputFluid = inputFluid;
        this.output = output;
        this.outputFluid = outputFluid == null ? FluidStack.EMPTY : outputFluid;
        this.consumeIngredient = consumeIngredient;
        this.additionalMainOutputChance = additionalMainOutputChance;
    }

    public static ARCPotionRecipeBuilder arc(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid) {
        return new ARCPotionRecipeBuilder(input, arcTool, inputFluid, output, outputFluid, false, 0.0);
    }

    public static ARCPotionRecipeBuilder arcConsume(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid) {
        return new ARCPotionRecipeBuilder(input, arcTool, inputFluid, output, outputFluid, true, 0.0);
    }

    public ARCPotionRecipeBuilder setRequiredInputCount(int inputSize) {
        if (inputSize > 0) {
            this.inputSize = inputSize;
        }
        return this;
    }

    public ARCPotionRecipeBuilder addRandomOutput(ItemStack stack, double secondaryChance) {
        return this.addRandomOutput(stack, 0.0, secondaryChance);
    }

    public ARCPotionRecipeBuilder addRandomOutput(ItemStack stack, double mainChance, double secondaryChance) {
        if (this.addedItems.size() >= 3 || mainChance < 0.0 || secondaryChance < 0.0) {
            return this;
        }
        this.addedItems.add((Pair<ItemStack, Pair<Double, Double>>)Pair.of((Object)stack, (Object)Pair.of((Object)mainChance, (Object)secondaryChance)));
        return this;
    }

    @Override
    protected ARCRecipeResult getResult(ResourceLocation id) {
        return new ARCRecipeResult(id);
    }

    public class ARCRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected ARCRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("input", ARCPotionRecipeBuilder.this.input.m_43942_());
            json.addProperty("inputsize", (Number)ARCPotionRecipeBuilder.this.inputSize);
            json.add("tool", ARCPotionRecipeBuilder.this.arcTool.m_43942_());
            if (ARCPotionRecipeBuilder.this.inputFluid != null) {
                json.add("inputFluid", ARCPotionRecipeBuilder.this.inputFluid.serialize());
            }
            if (ARCPotionRecipeBuilder.this.addedItems.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Pair<ItemStack, Pair<Double, Double>> pair : ARCPotionRecipeBuilder.this.addedItems) {
                    JsonObject jsonObj = new JsonObject();
                    jsonObj.addProperty("mainchance", (Number)Float.valueOf(((Double)((Pair)pair.getValue()).getLeft()).floatValue()));
                    jsonObj.addProperty("chance", (Number)Float.valueOf(((Double)((Pair)pair.getValue()).getRight()).floatValue()));
                    jsonObj.add("type", SerializerHelper.serializeItemStack((ItemStack)pair.getKey()));
                    mainArray.add((JsonElement)jsonObj);
                }
                json.add("addedoutput", (JsonElement)mainArray);
            }
            if (ARCPotionRecipeBuilder.this.outputFluid != null && !ARCPotionRecipeBuilder.this.outputFluid.isEmpty()) {
                json.add("outputFluid", SerializerHelper.serializeFluidStack(ARCPotionRecipeBuilder.this.outputFluid));
            }
            json.add("output", SerializerHelper.serializeItemStack(ARCPotionRecipeBuilder.this.output));
            json.addProperty("consumeingredient", Boolean.valueOf(ARCPotionRecipeBuilder.this.consumeIngredient));
            json.addProperty("mainoutputchance", (Number)ARCPotionRecipeBuilder.this.additionalMainOutputChance);
        }
    }
}

