/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDiscreteDemonWill;
import wayoftime.bloodmagic.common.item.ItemBloodOrb;
import wayoftime.bloodmagic.common.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRitualReaderState;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class ItemRitualReader
extends Item {
    public static final String tooltipBase = "tooltip.bloodmagic.ritualReader.";

    public ItemRitualReader() {
        super(new Item.Properties().m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        EnumRitualReaderState state = this.getState(stack);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.ritualReader.currentState", (Object[])new Object[]{TextHelper.localizeEffect(tooltipBase + state.toString().toLowerCase(Locale.ROOT), new Object[0])}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)""));
        boolean sneaking = Screen.m_96638_();
        if (sneaking) {
            tooltip.add((Component)Component.m_237115_((String)("tooltip.bloodmagic.ritualReader.desc." + state.toString().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.extraInfo").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult ray = Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.m_6144_()) {
            if (!world.f_46443_) {
                this.cycleReader(stack, player);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        InteractionHand hand = context.m_43724_();
        Direction direction = context.m_43719_();
        if (!world.f_46443_) {
            BlockPos masterPos;
            EnumRitualReaderState state = this.getState(stack);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof IMasterRitualStone) {
                IMasterRitualStone master = (IMasterRitualStone)tile;
                if (master.getCurrentRitual() == null) {
                    super.m_6225_(context);
                }
                this.setMasterBlockPos(stack, pos);
                this.setBlockPos(stack, BlockPos.f_121853_);
                switch (state) {
                    case INFORMATION: {
                        master.provideInformationOfRitualToPlayer(player);
                        break;
                    }
                    case SET_AREA: {
                        if (player.m_6144_() && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ItemBloodOrb) {
                            Ritual ritual = master.getCurrentRitual();
                            for (String range : ritual.getListOfRanges()) {
                                AreaDescriptor aabb = ritual.getBlockRange(range);
                                master.setBlockRange(range, aabb);
                            }
                            break;
                        }
                        String range = this.getCurrentBlockRange(stack);
                        if (range == null || range.isEmpty() || player.m_6144_()) {
                            String newRange;
                            range = newRange = master.getNextBlockRange(range);
                            this.setCurrentBlockRange(stack, newRange);
                        }
                        master.provideInformationOfRangeToPlayer(player, range);
                        break;
                    }
                    case SET_WILL_TYPES: {
                        ArrayList<EnumDemonWillType> typeList = new ArrayList<EnumDemonWillType>();
                        NonNullList inv = player.m_150109_().f_35974_;
                        for (int i = 0; i < 9; ++i) {
                            EnumDemonWillType type;
                            ItemStack testStack = (ItemStack)inv.get(i);
                            if (testStack.m_41619_() || !(testStack.m_41720_() instanceof IDiscreteDemonWill) || typeList.contains((Object)(type = ((IDiscreteDemonWill)testStack.m_41720_()).getType(testStack)))) continue;
                            typeList.add(type);
                        }
                        master.setActiveWillConfig(player, typeList);
                        master.provideInformationOfWillConfigToPlayer(player, typeList);
                    }
                }
                return InteractionResult.FAIL;
            }
            if (state == EnumRitualReaderState.SET_AREA && !(masterPos = this.getMasterBlockPos(stack)).equals((Object)BlockPos.f_121853_)) {
                BlockPos containedPos = this.getBlockPos(stack);
                if (containedPos.equals((Object)BlockPos.f_121853_)) {
                    BlockPos pos1 = pos.m_121996_((Vec3i)masterPos);
                    this.setBlockPos(stack, pos1);
                    player.m_5661_((Component)Component.m_237115_((String)"ritual.bloodmagic.blockRange.firstBlock"), true);
                } else {
                    tile = world.m_7702_(masterPos);
                    if (tile instanceof IMasterRitualStone) {
                        IMasterRitualStone master = (IMasterRitualStone)tile;
                        BlockPos pos2 = pos.m_121996_((Vec3i)masterPos);
                        String range = this.getCurrentBlockRange(stack);
                        if (range == null || range.isEmpty()) {
                            String newRange;
                            range = newRange = master.getNextBlockRange(range);
                            this.setCurrentBlockRange(stack, newRange);
                        }
                        Ritual ritual = master.getCurrentRitual();
                        List<EnumDemonWillType> willConfig = master.getActiveWillConfig();
                        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(master.getWorldObj(), master.getMasterBlockPos());
                        int maxHorizontalRange = ritual.getMaxHorizontalRadiusForRange(range, willConfig, holder);
                        int maxVerticalRange = ritual.getMaxVerticalRadiusForRange(range, willConfig, holder);
                        int maxVolume = ritual.getMaxVolumeForRange(range, willConfig, holder);
                        switch (master.setBlockRangeByBounds(player, range, containedPos, pos2)) {
                            case SUCCESS: {
                                player.m_5661_((Component)Component.m_237115_((String)"ritual.bloodmagic.blockRange.success"), true);
                                break;
                            }
                            case NOT_WITHIN_BOUNDARIES: {
                                player.m_5661_((Component)Component.m_237110_((String)"ritual.bloodmagic.blockRange.tooFar", (Object[])new Object[]{maxVerticalRange, maxHorizontalRange}), false);
                                break;
                            }
                            case VOLUME_TOO_LARGE: {
                                player.m_5661_((Component)Component.m_237110_((String)"ritual.bloodmagic.blockRange.tooBig", (Object[])new Object[]{maxVolume}), false);
                                break;
                            }
                            default: {
                                player.m_5661_((Component)Component.m_237115_((String)"ritual.bloodmagic.blockRange.noRange"), false);
                            }
                        }
                    }
                    this.setBlockPos(stack, BlockPos.f_121853_);
                }
            }
        } else {
            BlockEntity tile;
            EnumRitualReaderState state = this.getState(stack);
            if (state == EnumRitualReaderState.SET_AREA && (tile = world.m_7702_(pos)) instanceof TileMasterRitualStone) {
                ClientHandler.setRitualRangeHolo((TileMasterRitualStone)tile, true);
            }
        }
        return super.m_6225_(context);
    }

    public BlockPos getBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.m_41783_().m_128451_("xCoord"), stack.m_41783_().m_128451_("yCoord"), stack.m_41783_().m_128451_("zCoord"));
    }

    public ItemStack setBlockPos(ItemStack stack, BlockPos pos) {
        stack = NBTHelper.checkNBT(stack);
        CompoundTag itemTag = stack.m_41783_();
        itemTag.m_128405_("xCoord", pos.m_123341_());
        itemTag.m_128405_("yCoord", pos.m_123342_());
        itemTag.m_128405_("zCoord", pos.m_123343_());
        return stack;
    }

    public BlockPos getMasterBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.m_41783_().m_128451_("xCoordmaster"), stack.m_41783_().m_128451_("yCoordmaster"), stack.m_41783_().m_128451_("zCoordmaster"));
    }

    public ItemStack setMasterBlockPos(ItemStack stack, BlockPos pos) {
        stack = NBTHelper.checkNBT(stack);
        CompoundTag itemTag = stack.m_41783_();
        itemTag.m_128405_("xCoordmaster", pos.m_123341_());
        itemTag.m_128405_("yCoordmaster", pos.m_123342_());
        itemTag.m_128405_("zCoordmaster", pos.m_123343_());
        return stack;
    }

    public String getCurrentBlockRange(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128461_("range");
    }

    public void setCurrentBlockRange(ItemStack stack, String range) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128359_("range", range);
    }

    public void cycleReader(ItemStack stack, Player player) {
        EnumRitualReaderState prevState = this.getState(stack);
        int val = prevState.ordinal();
        int nextVal = val + 1 >= EnumRitualReaderState.values().length ? 0 : val + 1;
        EnumRitualReaderState nextState = EnumRitualReaderState.values()[nextVal];
        this.setState(stack, nextState);
        this.notifyPlayerOfStateChange(nextState, player);
    }

    public void notifyPlayerOfStateChange(EnumRitualReaderState state, Player player) {
        ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"tooltip.bloodmagic.ritualReader.currentState", (Object[])new Object[]{Component.m_237115_((String)(tooltipBase + state.toString().toLowerCase(Locale.ROOT)))})});
    }

    public void setState(ItemStack stack, EnumRitualReaderState state) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128405_("ritualReaderState", state.ordinal());
    }

    public EnumRitualReaderState getState(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
            return EnumRitualReaderState.INFORMATION;
        }
        CompoundTag tag = stack.m_41783_();
        return EnumRitualReaderState.values()[tag.m_128451_("ritualReaderState")];
    }
}

