/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.common.loot.BloodMagicLootFunctionManager;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;

public class SetLivingUpgrade
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final UniformGenerator pointsRange;
    private final List<ResourceLocation> livingUpgrades;

    private SetLivingUpgrade(LootItemCondition[] conditionsIn, List<ResourceLocation> livingUpgrades, UniformGenerator damageRangeIn) {
        super(conditionsIn);
        this.pointsRange = damageRangeIn;
        this.livingUpgrades = livingUpgrades;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)BloodMagicLootFunctionManager.SET_LIVING_UPGRADE.get();
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (stack.m_41720_() instanceof ILivingContainer) {
            Collections.shuffle(this.livingUpgrades);
            ResourceLocation upgrade = this.livingUpgrades.get(0);
            float points = this.pointsRange.m_142688_(context);
            LivingStats stats = new LivingStats();
            stats.addExperience(upgrade, points);
            ((ILivingContainer)stack.m_41720_()).updateLivingStats(stack, stats);
        } else {
            LOGGER.warn("Couldn't set will of loot item {}", (Object)stack);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> withRange(UniformGenerator p_215931_0_, ResourceLocation ... livingUpgrades) {
        return SetLivingUpgrade.m_80683_(p_215930_1_ -> {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            for (ResourceLocation resource : livingUpgrades) {
                list.add(resource);
            }
            return new SetLivingUpgrade((LootItemCondition[])p_215930_1_, (List<ResourceLocation>)list, p_215931_0_);
        });
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetLivingUpgrade> {
        public void serialize(JsonObject json, SetLivingUpgrade p_230424_2_, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)p_230424_2_, context);
            if (p_230424_2_.livingUpgrades.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (ResourceLocation ing : p_230424_2_.livingUpgrades) {
                    mainArray.add(ing.toString());
                }
                json.add("upgrades", (JsonElement)mainArray);
            }
            json.add("points", context.serialize((Object)p_230424_2_.pointsRange));
        }

        public SetLivingUpgrade deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            ArrayList<ResourceLocation> inputList = new ArrayList<ResourceLocation>();
            if (json.has("upgrades") && GsonHelper.m_13885_((JsonObject)json, (String)"upgrades")) {
                JsonArray mainArray = GsonHelper.m_13933_((JsonObject)json, (String)"upgrades");
                for (JsonElement element : mainArray) {
                    String resource = element.getAsString();
                    inputList.add(new ResourceLocation(resource));
                }
            }
            return new SetLivingUpgrade(conditionsIn, inputList, (UniformGenerator)GsonHelper.m_13836_((JsonObject)json, (String)"points", (JsonDeserializationContext)deserializationContext, UniformGenerator.class));
        }
    }
}

