/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.common.item.dungeon.IDungeonKey;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.base.TileBase;
import wayoftime.bloodmagic.structures.DungeonRoom;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;

public class TileDungeonController
extends TileBase {
    private DungeonSynthesizer dungeon = null;

    public TileDungeonController(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileDungeonController(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.DUNGEON_CONTROLLER_TYPE.get(), pos, state);
    }

    public void setDungeonSynthesizer(DungeonSynthesizer dungeon) {
        this.dungeon = dungeon;
        this.dungeon.setDungeonController(this);
        this.m_6596_();
    }

    public int handleRequestForRoomPlacement(Player player, ItemStack keyStack, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, int activatedRoomDepth, int highestBranchRoomDepth, List<ResourceLocation> potentialRooms) {
        if (!this.f_58857_.f_46443_ && this.f_58857_ instanceof ServerLevel && !keyStack.m_41619_() && keyStack.m_41720_() instanceof IDungeonKey) {
            ResourceLocation roomType = ((IDungeonKey)keyStack.m_41720_()).getValidResourceLocation(potentialRooms);
            if (roomType == null) {
                return -1;
            }
            int placementState = this.dungeon.addNewRoomToExistingDungeon(player, (ServerLevel)this.f_58857_, this.m_58899_(), roomType, this.f_58857_.f_46441_, activatedDoorPos, doorFacing, activatedDoorType, potentialRooms, activatedRoomDepth, highestBranchRoomDepth);
            if (placementState == 0) {
                keyStack.m_41774_(1);
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_58857_);
                lightningboltentity.m_6034_((double)activatedDoorPos.m_123341_(), (double)activatedDoorPos.m_123342_(), (double)activatedDoorPos.m_123343_());
                lightningboltentity.m_20874_(true);
                this.f_58857_.m_7967_((Entity)lightningboltentity);
            }
            return placementState;
        }
        return -1;
    }

    public int handleRequestForPredesignatedRoomPlacement(Player player, ItemStack keyStack, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, int activatedRoomDepth, int highestBranchRoomDepth, List<ResourceLocation> potentialRooms, DungeonRoom room, Rotation rotation, BlockPos roomLocation) {
        if (!this.f_58857_.f_46443_ && this.f_58857_ instanceof ServerLevel && !keyStack.m_41619_() && keyStack.m_41720_() instanceof IDungeonKey) {
            ResourceLocation roomType = ((IDungeonKey)keyStack.m_41720_()).getValidResourceLocation(potentialRooms);
            if (roomType == null) {
                return -1;
            }
            boolean didPlace = this.dungeon.forcePlacementOfRoom(player, (ServerLevel)this.f_58857_, this.m_58899_(), doorFacing, activatedDoorPos, activatedDoorType, activatedRoomDepth, highestBranchRoomDepth, room, rotation, roomLocation);
            if (didPlace) {
                keyStack.m_41774_(1);
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_58857_);
                lightningboltentity.m_6034_((double)activatedDoorPos.m_123341_(), (double)activatedDoorPos.m_123342_(), (double)activatedDoorPos.m_123343_());
                lightningboltentity.m_20874_(true);
                this.f_58857_.m_7967_((Entity)lightningboltentity);
            }
        }
        return 1;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        if (tag.m_128441_("dungeon_controller")) {
            CompoundTag synthesizerTag = tag.m_128469_("dungeon_controller");
            this.dungeon = new DungeonSynthesizer();
            this.dungeon.readFromNBT(synthesizerTag);
        } else {
            this.dungeon = new DungeonSynthesizer();
        }
        this.dungeon.setDungeonController(this);
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        if (this.dungeon != null) {
            CompoundTag synthesizerTag = new CompoundTag();
            this.dungeon.writeToNBT(synthesizerTag);
            tag.m_128365_("dungeon_controller", (Tag)synthesizerTag);
        }
        return tag;
    }
}

