/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileExplosiveCharge;

public class TileShapedExplosive
extends TileExplosiveCharge {
    public double internalCounter = 0.0;
    public int explosionRadius;
    public int explosionDepth;

    public TileShapedExplosive(BlockEntityType<?> type, int explosionRadius, int explosionDepth, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.explosionRadius = explosionRadius;
        this.explosionDepth = explosionDepth;
    }

    public TileShapedExplosive(BlockPos pos, BlockState state) {
        this(2, 5, pos, state);
    }

    public TileShapedExplosive(int explosionRadius, int explosionDepth, BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.SHAPED_EXPLOSIVE_TYPE.get(), explosionRadius, explosionDepth, pos, state);
    }

    @Override
    public void onUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.internalCounter += 1.0;
        if (this.internalCounter == 20.0) {
            this.f_58857_.m_6263_((Player)null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 0.8f);
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 5, 0.02, 0.03, 0.02, 0.0);
        }
        if (this.internalCounter == 30.0) {
            this.f_58857_.m_6263_((Player)null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.internalCounter < 30.0) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.3) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.internalCounter == 100.0) {
            this.f_58857_.m_6263_((Player)null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            Direction explosiveDirection = ((Direction)this.m_58900_().m_61143_(BlockShapedExplosive.ATTACHED)).m_122424_();
            Direction sweepDir1 = Direction.UP;
            Direction sweepDir2 = Direction.UP;
            int numParticles = this.explosionDepth * (this.explosionRadius + 1);
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)this.f_58858_.m_123341_() + 0.5 + (double)(explosiveDirection.m_122429_() * this.explosionDepth) / 2.0, (double)this.f_58858_.m_123342_() + 0.5 + (double)(explosiveDirection.m_122430_() * this.explosionDepth) / 2.0, (double)this.f_58858_.m_123343_() + 0.5 + (double)(explosiveDirection.m_122431_() * this.explosionDepth) / 2.0, numParticles, 1.0, 1.0, 1.0, 0.0);
            switch (explosiveDirection) {
                case UP: 
                case DOWN: {
                    sweepDir1 = Direction.NORTH;
                    sweepDir2 = Direction.EAST;
                    break;
                }
                case EAST: 
                case WEST: {
                    sweepDir1 = Direction.NORTH;
                    sweepDir2 = Direction.UP;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    sweepDir1 = Direction.EAST;
                    sweepDir2 = Direction.UP;
                }
            }
            ItemStack toolStack = this.getHarvestingTool();
            ObjectArrayList objectarraylist = new ObjectArrayList();
            BlockPos initialPos = this.m_58899_();
            for (int i = 1; i <= this.explosionDepth; ++i) {
                for (int j = -this.explosionRadius; j <= this.explosionRadius; ++j) {
                    for (int k = -this.explosionRadius; k <= this.explosionRadius; ++k) {
                        BlockPos blockpos = initialPos.m_5484_(explosiveDirection, i).m_5484_(sweepDir1, j).m_5484_(sweepDir2, k);
                        BlockState blockstate = this.f_58857_.m_8055_(blockpos);
                        Block block = blockstate.m_60734_();
                        if (blockstate.m_60795_() || blockstate.m_60800_((BlockGetter)this.f_58857_, blockpos) == -1.0f) continue;
                        BlockPos blockpos1 = blockpos.m_7949_();
                        if (!(this.f_58857_ instanceof ServerLevel)) continue;
                        BlockEntity tileentity = blockstate.m_60734_() instanceof EntityBlock ? this.f_58857_.m_7702_(blockpos) : null;
                        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)toolStack).m_287289_(LootContextParams.f_81462_, (Object)tileentity);
                        blockstate.m_287290_(lootcontext$builder).forEach(stack -> TileShapedExplosive.handleExplosionDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, blockpos1));
                        this.f_58857_.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
            this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.internalCounter = tag.m_128459_("internalCounter");
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        tag.m_128347_("internalCounter", this.internalCounter);
        return tag;
    }
}

