/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile.base;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.common.tile.base.TileBase;

public abstract class TileTicking
extends TileBase {
    private int ticksExisted;
    private boolean shouldTick = true;

    public TileTicking(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public final void tick() {
        if (this.shouldTick()) {
            ++this.ticksExisted;
            this.onUpdate();
        }
    }

    @Override
    void deserializeBase(CompoundTag tagCompound) {
        this.ticksExisted = tagCompound.m_128451_("ticksExisted");
        this.shouldTick = tagCompound.m_128471_("shouldTick");
    }

    @Override
    CompoundTag serializeBase(CompoundTag tagCompound) {
        tagCompound.m_128405_("ticksExisted", this.getTicksExisted());
        tagCompound.m_128379_("shouldTick", this.shouldTick());
        return tagCompound;
    }

    public abstract void onUpdate();

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public void resetLifetime() {
        this.ticksExisted = 0;
    }

    public boolean shouldTick() {
        return this.shouldTick;
    }

    public void setShouldTick(boolean shouldTick) {
        this.shouldTick = shouldTick;
    }
}

