/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.recipe.RecipeLivingDowngrade;
import wayoftime.bloodmagic.recipe.RecipeMeteor;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class BloodMagicRecipeRegistrar {
    @Nullable
    public RecipeBloodAltar getBloodAltar(Level world, @Nonnull ItemStack input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.m_41619_()) {
            return null;
        }
        List altarRecipes = world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ALTAR.get());
        for (RecipeBloodAltar recipe : altarRecipes) {
            if (!recipe.getInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    public RecipeARC getARC(Level world, @Nonnull ItemStack input, @Nonnull ItemStack arcToolInput, @Nonnull FluidStack inputFluid) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)arcToolInput, (Object)"tool cannot be null.");
        if (input.m_41619_() || arcToolInput.m_41619_()) {
            return null;
        }
        List arcRecipes = world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ARC.get());
        for (RecipeARC recipe : arcRecipes) {
            if (!recipe.getInput().test(input) || !recipe.getTool().test(arcToolInput)) continue;
            if (recipe.getFluidIngredient() == null) {
                return recipe;
            }
            if (!recipe.getFluidIngredient().test(inputFluid)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipeAlchemyTable getAlchemyTable(Level world, @Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        List tartaricForgeRecipes = world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ALCHEMYTABLE.get());
        block0: for (RecipeAlchemyTable recipe : tartaricForgeRecipes) {
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>(recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.test(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipeMeteor getMeteor(Level world, @Nonnull ItemStack input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.m_41619_()) {
            return null;
        }
        List meteorRecipes = world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.METEOR.get());
        for (RecipeMeteor recipe : meteorRecipes) {
            if (!recipe.getInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipePotionFlaskBase getPotionFlaskRecipe(Level world, ItemStack flaskStack, @Nonnull List<EffectHolder> holderList, @Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        List potionRecipes = world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.POTIONFLASK.get());
        RecipePotionFlaskBase validRecipe = null;
        int recipePriority = Integer.MIN_VALUE;
        block0: for (RecipePotionFlaskBase recipe : potionRecipes) {
            int prio;
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>(recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.test(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            if (!recipe.canModifyFlask(flaskStack, holderList) || (prio = recipe.getPriority(holderList)) <= recipePriority) continue;
            validRecipe = recipe;
            recipePriority = prio;
        }
        return validRecipe;
    }

    @Nullable
    public RecipeTartaricForge getTartaricForge(Level world, @Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        List tartaricForgeRecipes = world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.TARTARICFORGE.get());
        block0: for (RecipeTartaricForge recipe : tartaricForgeRecipes) {
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>(recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.test(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            return recipe;
        }
        return null;
    }

    @Nullable
    public Pair<Boolean, RecipeAlchemyArray> getAlchemyArray(Level world, @Nonnull ItemStack input, @Nonnull ItemStack catalyst) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.m_41619_()) {
            return null;
        }
        List altarRecipes = world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ARRAY.get());
        RecipeAlchemyArray partialMatch = null;
        for (RecipeAlchemyArray recipe : altarRecipes) {
            if (!recipe.getBaseInput().test(input)) continue;
            if (recipe.getAddedInput().test(catalyst)) {
                return Pair.of((Object)true, (Object)recipe);
            }
            if (partialMatch != null) continue;
            partialMatch = recipe;
        }
        return Pair.of((Object)false, partialMatch);
    }

    @Nullable
    public RecipeLivingDowngrade getLivingDowngrade(Level world, @Nonnull ItemStack input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.m_41619_()) {
            return null;
        }
        List downgradeRecipes = world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.LIVINGDOWNGRADE.get());
        for (RecipeLivingDowngrade recipe : downgradeRecipes) {
            if (!recipe.getInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    public List<RecipeBloodAltar> getAltarRecipes(Level world) {
        return ImmutableList.copyOf((Collection)world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ALTAR.get()));
    }

    public List<RecipeTartaricForge> getTartaricForgeRecipes(Level world) {
        return ImmutableList.copyOf((Collection)world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.TARTARICFORGE.get()));
    }

    public List<RecipeAlchemyArray> getAlchemyArrayRecipes(Level world) {
        return ImmutableList.copyOf((Collection)world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ARRAY.get()));
    }

    public List<RecipeARC> getARCRecipes(Level world) {
        return ImmutableList.copyOf((Collection)world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ARC.get()));
    }

    public List<RecipeAlchemyTable> getAlchemyTableRecipes(Level world) {
        return ImmutableList.copyOf((Collection)world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ALCHEMYTABLE.get()));
    }

    public List<RecipePotionFlaskBase> getPotionFlaskRecipes(Level world) {
        return ImmutableList.copyOf((Collection)world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.POTIONFLASK.get()));
    }

    public Set<RecipeAlchemyArray> getCraftingAlchemyArrayRecipes(Level world) {
        HashSet recipes = new HashSet(world.m_7465_().m_44013_((RecipeType)BloodMagicRecipeType.ARRAY.get()));
        HashSet<RecipeAlchemyArray> copyRecipes = new HashSet<RecipeAlchemyArray>();
        for (RecipeAlchemyArray recipe : recipes) {
            if (recipe.getOutput().m_41619_()) continue;
            copyRecipes.add(recipe);
        }
        return copyRecipes;
    }
}

