/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.core.AnointmentRegistrar;

public class GlobalLootModifier {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"bloodmagic");
    public static final RegistryObject<Codec<SilkTouchTestModifier>> SILKTOUCH = GLM.register("silk_touch_bamboo", SilkTouchTestModifier.CODEC);
    public static final RegistryObject<Codec<FortuneModifier>> FORTUNE = GLM.register("fortune", FortuneModifier.CODEC);
    public static final RegistryObject<Codec<LootingModifier>> LOOTING = GLM.register("looting", LootingModifier.CODEC);
    public static final RegistryObject<Codec<SmeltingModifier>> SMELT = GLM.register("smelt", SmeltingModifier.CODEC);
    public static final RegistryObject<Codec<VoidingModifier>> VOID = GLM.register("voiding", VoidingModifier.CODEC);

    private static class SilkTouchTestModifier
    extends LootModifier {
        public static final Supplier<Codec<SilkTouchTestModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SilkTouchTestModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SilkTouchTestModifier::new)));

        public SilkTouchTestModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (EnchantmentHelper.m_44831_((ItemStack)ctxTool).containsKey(Enchantments.f_44985_)) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null || holder.getAnointmentLevel((Anointment)AnointmentRegistrar.ANOINTMENT_SILK_TOUCH.get()) <= 0) {
                return generatedLoot;
            }
            ItemStack fakeTool = ctxTool.m_41777_();
            fakeTool.m_41663_(Enchantments.f_44985_, 1);
            LootParams.Builder builder = new LootParams.Builder(context.m_78952_());
            builder.m_287286_(LootContextParams.f_81463_, (Object)fakeTool);
            LootParams ctx = builder.m_287235_(LootContextParamSets.f_81410_);
            LootTable loottable = context.m_78952_().m_7654_().m_278653_().m_278676_(((BlockState)context.m_78953_(LootContextParams.f_81461_)).m_60734_().m_60589_());
            return loottable.m_287195_(ctx);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    private static class FortuneModifier
    extends LootModifier {
        public static final Supplier<Codec<FortuneModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> FortuneModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, FortuneModifier::new)));

        public FortuneModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (ctxTool.m_41783_() != null && ctxTool.m_41783_().m_128471_("bloodmagic:checked_fortune")) {
                return generatedLoot;
            }
            if (EnchantmentHelper.m_44831_((ItemStack)ctxTool).containsKey(Enchantments.f_44985_)) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null) {
                return generatedLoot;
            }
            int additionalFortune = holder.getAnointmentLevel((Anointment)AnointmentRegistrar.ANOINTMENT_FORTUNE.get());
            if (additionalFortune <= 0) {
                return generatedLoot;
            }
            ItemStack fakeTool = ctxTool.m_41777_();
            fakeTool.m_41784_().m_128379_("bloodmagic:checked_fortune", true);
            int baseFortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)ctxTool);
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)fakeTool);
            enchants.put(Enchantments.f_44987_, baseFortuneLevel + additionalFortune);
            EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)fakeTool);
            LootParams.Builder builder = new LootParams.Builder(context.m_78952_());
            builder.m_287286_(LootContextParams.f_81463_, (Object)fakeTool);
            LootParams ctx = builder.m_287235_(LootContextParamSets.f_81410_);
            LootTable loottable = context.m_78952_().m_7654_().m_278653_().m_278676_(((BlockState)context.m_78953_(LootContextParams.f_81461_)).m_60734_().m_60589_());
            return loottable.m_287195_(ctx);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    private static class LootingModifier
    extends LootModifier {
        public static final Supplier<Codec<LootingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootingModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, LootingModifier::new)));

        public LootingModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    private static class SmeltingModifier
    extends LootModifier {
        public static final Supplier<Codec<SmeltingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SmeltingModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SmeltingModifier::new)));

        public SmeltingModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (ctxTool.m_41783_() == null) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null) {
                return generatedLoot;
            }
            int smeltingLevel = holder.getAnointmentLevel((Anointment)AnointmentRegistrar.ANOINTMENT_SMELTING.get());
            if (smeltingLevel <= 0) {
                return generatedLoot;
            }
            ObjectArrayList ret = new ObjectArrayList();
            generatedLoot.forEach(stack -> ret.add((Object)SmeltingModifier.smelt(stack, context)));
            return ret;
        }

        private static ItemStack smelt(ItemStack stack, LootContext context) {
            return context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_()).map(a -> a.m_8043_(context.m_78952_().m_9598_())).filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.m_41613_() * itemStack.m_41613_()))).orElse(stack);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    private static class VoidingModifier
    extends LootModifier {
        public static final Supplier<Codec<VoidingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> VoidingModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, VoidingModifier::new)));

        public VoidingModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
            if (blockState == null) {
                return generatedLoot;
            }
            if (!blockState.m_204336_(BloodMagicTags.Blocks.MUNDANE_BLOCK)) {
                return generatedLoot;
            }
            ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (ctxTool.m_41783_() == null) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null) {
                return generatedLoot;
            }
            int voidingLevel = holder.getAnointmentLevel((Anointment)AnointmentRegistrar.ANOINTMENT_VOIDING.get());
            if (voidingLevel <= 0) {
                return generatedLoot;
            }
            ObjectArrayList ret = new ObjectArrayList();
            return ret;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

