/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class EffectHolder {
    private final MobEffect potion;
    private int baseDuration;
    private int amplifier;
    private double ampDurationMod;
    private double lengthDurationMod;

    public EffectHolder(MobEffect potion, int baseDuration, int amplifier, double ampDurationMod, double lengthDurationMod) {
        this.potion = potion;
        this.baseDuration = baseDuration;
        this.amplifier = amplifier;
        this.ampDurationMod = ampDurationMod;
        this.lengthDurationMod = lengthDurationMod;
    }

    public MobEffectInstance getEffectInstance(boolean ambientIn, boolean showParticlesIn) {
        return this.getEffectInstance(1.0, ambientIn, showParticlesIn);
    }

    public MobEffectInstance getEffectInstance(double durationModifier, boolean ambientIn, boolean showParticlesIn) {
        return new MobEffectInstance(this.potion, (int)((double)this.baseDuration * this.ampDurationMod * this.lengthDurationMod * durationModifier), this.amplifier, ambientIn, showParticlesIn);
    }

    public MobEffect getPotion() {
        return this.potion;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getBaseDuration() {
        return this.baseDuration;
    }

    public double getAmpDurationMod() {
        return this.ampDurationMod;
    }

    public double getLengthDurationMod() {
        return this.lengthDurationMod;
    }

    public void setBaseDuration(int baseDuration) {
        this.baseDuration = baseDuration;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public void setAmpDurationMod(double ampDurationMod) {
        this.ampDurationMod = ampDurationMod;
    }

    public void setLengthDurationMod(double lengthDurationMod) {
        this.lengthDurationMod = lengthDurationMod;
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128405_("Id", MobEffect.m_19459_((MobEffect)this.getPotion()));
        this.writeInternal(nbt);
        return nbt;
    }

    private void writeInternal(CompoundTag nbt) {
        nbt.m_128344_("Amplifier", (byte)this.getAmplifier());
        nbt.m_128405_("Duration", this.getBaseDuration());
        nbt.m_128347_("AmpDurationMod", this.getAmpDurationMod());
        nbt.m_128347_("LengthDurationMod", this.getLengthDurationMod());
    }

    public static EffectHolder read(CompoundTag nbt) {
        int i = nbt.m_128451_("Id");
        MobEffect effect = MobEffect.m_19453_((int)i);
        return effect == null ? null : EffectHolder.readInternal(effect, nbt);
    }

    private static EffectHolder readInternal(MobEffect effect, CompoundTag nbt) {
        byte amplifier = nbt.m_128445_("Amplifier");
        int baseDuration = nbt.m_128451_("Duration");
        double ampDurationMod = nbt.m_128459_("AmpDurationMod");
        double lengthDurationMod = nbt.m_128459_("LengthDurationMod");
        return new EffectHolder(effect, baseDuration, amplifier, ampDurationMod, lengthDurationMod);
    }
}

