/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import wayoftime.bloodmagic.common.item.routing.ICompositeItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;

public class RecipeFilterMergeAlchemyTable
extends RecipeAlchemyTable {
    final Ingredient filterIngredient;

    public RecipeFilterMergeAlchemyTable(ResourceLocation id, Ingredient filterIngredient, List<Ingredient> input, ItemStack output, int syphon, int ticks, int minimumTier) {
        super(id, input, output, syphon, ticks, minimumTier);
        this.filterIngredient = filterIngredient;
    }

    @Override
    @Nonnull
    public ItemStack getOutput(List<ItemStack> inputs) {
        int index = -1;
        for (int i = 0; i < inputs.size(); ++i) {
            if (!this.filterIngredient.test(inputs.get(i))) continue;
            index = i;
        }
        if (index == -1) {
            return ItemStack.f_41583_;
        }
        ItemStack filterStack = inputs.get(index);
        if (!(filterStack.m_41720_() instanceof ICompositeItemFilterProvider)) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            ItemStack inputStack;
            if (i == index || inputs.get(i).m_41619_() || !((inputStack = inputs.get(i)).m_41720_() instanceof INestableItemFilterProvider) || !((ICompositeItemFilterProvider)filterStack.m_41720_()).canReceiveNestedFilter(filterStack, inputStack)) continue;
            filterStack = ((ICompositeItemFilterProvider)filterStack.m_41720_()).nestFilter(filterStack, inputStack);
        }
        return filterStack;
    }

    @Override
    public List<Ingredient> getInput() {
        ArrayList<Ingredient> returnInputs = new ArrayList<Ingredient>(this.input);
        returnInputs.add(this.filterIngredient);
        return returnInputs;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.filterIngredient.m_43923_(buffer);
        super.write(buffer);
    }

    public RecipeSerializer<RecipeFilterMergeAlchemyTable> m_7707_() {
        return BloodMagicRecipeSerializers.FILTERALCHEMYTABLE.getRecipeSerializer();
    }
}

