/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class RecipePotionCycle
extends RecipePotionFlaskBase {
    public int numCycles;

    public RecipePotionCycle(ResourceLocation id, List<Ingredient> input, int numCycles, int syphon, int ticks, int minimumTier) {
        super(id, input, syphon, ticks, minimumTier);
        this.numCycles = numCycles;
    }

    public RecipeSerializer<? extends RecipePotionCycle> m_7707_() {
        return BloodMagicRecipeSerializers.POTIONCYCLE.getRecipeSerializer();
    }

    @Override
    public RecipeType<RecipePotionFlaskBase> m_6671_() {
        return (RecipeType)BloodMagicRecipeType.POTIONFLASK.get();
    }

    @Override
    public boolean canModifyFlask(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        return flaskEffectList.size() >= 2;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(this.numCycles);
    }

    @Override
    public ItemStack getOutput(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        ItemStack copyStack = flaskStack.m_41777_();
        ArrayList<EffectHolder> flaskEffectCopyList = new ArrayList<EffectHolder>(flaskEffectList);
        for (int i = 0; i < this.numCycles; ++i) {
            EffectHolder holder = (EffectHolder)flaskEffectCopyList.remove(0);
            flaskEffectCopyList.add(holder);
        }
        ((ItemAlchemyFlask)copyStack.m_41720_()).setEffectHoldersOfFlask(copyStack, flaskEffectCopyList);
        return copyStack;
    }

    @Override
    public int getPriority(List<EffectHolder> flaskEffectList) {
        return 1;
    }

    @Override
    public List<EffectHolder> getExampleEffectList() {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        holderList.add(new EffectHolder(MobEffects.f_19596_, 3600, 0, 1.0, 1.0));
        holderList.add(new EffectHolder(MobEffects.f_19607_, 3600, 0, 1.0, 1.0));
        holderList.add(new EffectHolder(MobEffects.f_19598_, 3600, 0, 1.0, 1.0));
        return holderList;
    }
}

