/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class RecipePotionTransform
extends RecipePotionFlaskBase {
    public List<Pair<MobEffect, Integer>> outputEffectList;
    public List<MobEffect> inputEffectList;

    public RecipePotionTransform(ResourceLocation id, List<Ingredient> input, List<Pair<MobEffect, Integer>> outputEffectList, List<MobEffect> inputEffectList, int syphon, int ticks, int minimumTier) {
        super(id, input, syphon, ticks, minimumTier);
        this.outputEffectList = outputEffectList;
        this.inputEffectList = inputEffectList;
    }

    public RecipeSerializer<? extends RecipePotionTransform> m_7707_() {
        return BloodMagicRecipeSerializers.POTIONTRANSFORM.getRecipeSerializer();
    }

    @Override
    public RecipeType<RecipePotionFlaskBase> m_6671_() {
        return (RecipeType)BloodMagicRecipeType.POTIONFLASK.get();
    }

    @Override
    public boolean canModifyFlask(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        if (flaskEffectList.size() < this.inputEffectList.size()) {
            return false;
        }
        int duplicateCount = this.getDuplicateEffects(flaskEffectList);
        if (duplicateCount >= this.outputEffectList.size()) {
            return false;
        }
        ArrayList<MobEffect> recipeInput = new ArrayList<MobEffect>(this.inputEffectList);
        for (int i = 0; i < flaskEffectList.size(); ++i) {
            MobEffect flaskEffect = flaskEffectList.get(i).getPotion();
            boolean matched = false;
            for (int j = 0; j < recipeInput.size(); ++j) {
                MobEffect ingredient = (MobEffect)recipeInput.get(j);
                if (!ingredient.equals(flaskEffect)) continue;
                recipeInput.remove(j);
                matched = true;
                break;
            }
            if (matched) continue;
        }
        return recipeInput.isEmpty();
    }

    protected int getDuplicateEffects(List<EffectHolder> flaskEffectList) {
        int duplicateCount = 0;
        ArrayList<Pair<MobEffect, Integer>> recipeOutput = new ArrayList<Pair<MobEffect, Integer>>(this.outputEffectList);
        block0: for (int i = 0; i < flaskEffectList.size(); ++i) {
            MobEffect flaskEffect = flaskEffectList.get(i).getPotion();
            int flaskBaseDuration = flaskEffectList.get(i).getBaseDuration();
            for (int j = 0; j < recipeOutput.size(); ++j) {
                Pair output = (Pair)recipeOutput.get(j);
                if (!((MobEffect)output.getKey()).equals(flaskEffect) || (Integer)output.getValue() > flaskBaseDuration) continue;
                recipeOutput.remove(j);
                ++duplicateCount;
                continue block0;
            }
        }
        return duplicateCount;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(this.outputEffectList.size());
        for (Pair<MobEffect, Integer> effectHolder : this.outputEffectList) {
            buffer.writeInt(MobEffect.m_19459_((MobEffect)((MobEffect)effectHolder.getKey())));
            buffer.writeInt(((Integer)effectHolder.getValue()).intValue());
        }
        buffer.writeInt(this.inputEffectList.size());
        for (MobEffect effect : this.inputEffectList) {
            buffer.writeInt(MobEffect.m_19459_((MobEffect)effect));
        }
    }

    @Override
    public ItemStack getOutput(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        int i;
        ItemStack copyStack = flaskStack.m_41777_();
        boolean savePotencies = this.outputEffectList.size() == 1 && this.inputEffectList.size() == 1;
        int amplifier = 0;
        double ampDurMod = 1.0;
        double lengthDurMod = 1.0;
        ArrayList<EffectHolder> flaskEffectCopyList = new ArrayList<EffectHolder>(flaskEffectList);
        block0: for (int i2 = 0; i2 < this.inputEffectList.size(); ++i2) {
            MobEffect inputEffect = this.inputEffectList.get(i2);
            for (int j = 0; j < flaskEffectCopyList.size(); ++j) {
                EffectHolder flaskEffect = (EffectHolder)flaskEffectCopyList.get(j);
                if (!flaskEffect.getPotion().equals(inputEffect)) continue;
                if (savePotencies) {
                    amplifier = flaskEffect.getAmplifier();
                    ampDurMod = flaskEffect.getAmpDurationMod();
                    lengthDurMod = flaskEffect.getLengthDurationMod();
                }
                flaskEffectCopyList.remove(j);
                continue block0;
            }
        }
        boolean[] alreadyAddedArray = new boolean[this.outputEffectList.size()];
        block2: for (i = 0; i < this.outputEffectList.size(); ++i) {
            MobEffect outputEffect = (MobEffect)this.outputEffectList.get(i).getKey();
            int outputBaseDuration = (Integer)this.outputEffectList.get(i).getValue();
            for (int j = 0; j < flaskEffectCopyList.size(); ++j) {
                EffectHolder flaskEffect = (EffectHolder)flaskEffectCopyList.get(j);
                if (!flaskEffect.getPotion().equals(outputEffect)) continue;
                alreadyAddedArray[i] = true;
                if (flaskEffect.getBaseDuration() >= outputBaseDuration) continue block2;
                flaskEffect.setBaseDuration(outputBaseDuration);
                continue block2;
            }
            alreadyAddedArray[i] = false;
        }
        for (i = 0; i < this.outputEffectList.size(); ++i) {
            flaskEffectCopyList.add(new EffectHolder((MobEffect)this.outputEffectList.get(i).getKey(), (Integer)this.outputEffectList.get(i).getValue(), amplifier, ampDurMod, lengthDurMod));
        }
        ((ItemAlchemyFlask)copyStack.m_41720_()).setEffectHoldersOfFlask(copyStack, flaskEffectCopyList);
        return copyStack;
    }

    @Override
    public int getPriority(List<EffectHolder> flaskEffectList) {
        int prio = 0;
        for (int i = 0; i < flaskEffectList.size(); ++i) {
            EffectHolder holder = flaskEffectList.get(i);
            for (int j = 0; j < this.inputEffectList.size(); ++j) {
                if (!holder.getPotion().equals(this.inputEffectList.get(j))) continue;
                prio += i + 1;
            }
        }
        return prio;
    }

    @Override
    public List<EffectHolder> getExampleEffectList() {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        for (MobEffect inputEffect : this.inputEffectList) {
            holderList.add(new EffectHolder(inputEffect, 3600, 0, 1.0, 1.0));
        }
        return holderList;
    }
}

