/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tile.TileDemonCrystal;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="crystal_split")
public class RitualCrystalSplit
extends Ritual {
    public RitualCrystalSplit() {
        super("ritualCrystalSplit", 0, 20000, "ritual.bloodmagic.crystalSplitRitual");
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        Direction direction = masterRitualStone.getDirection();
        BlockPos rawPos = pos.m_6630_(2);
        BlockEntity tile = world.m_7702_(rawPos);
        if (!(tile instanceof TileDemonCrystal) || ((TileDemonCrystal)tile).getWillType() != EnumDemonWillType.DEFAULT) {
            return;
        }
        BlockState rawState = world.m_8055_(rawPos);
        TileDemonCrystal rawTile = (TileDemonCrystal)tile;
        if (rawTile.getCrystalCount() >= 5) {
            BlockPos vengefulPos = pos.m_121945_(this.rotateFacing(Direction.NORTH, direction)).m_7494_();
            BlockPos corrosivePos = pos.m_121945_(this.rotateFacing(Direction.EAST, direction)).m_7494_();
            BlockPos steadfastPos = pos.m_121945_(this.rotateFacing(Direction.SOUTH, direction)).m_7494_();
            BlockPos destructivePos = pos.m_121945_(this.rotateFacing(Direction.WEST, direction)).m_7494_();
            int vengefulCrystals = 0;
            int corrosiveCrystals = 0;
            int steadfastCrystals = 0;
            int destructiveCrystals = 0;
            tile = world.m_7702_(vengefulPos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getWillType() == EnumDemonWillType.VENGEFUL && ((TileDemonCrystal)tile).getCrystalCount() < 7) {
                vengefulCrystals = ((TileDemonCrystal)tile).getCrystalCount();
            } else if (tile instanceof TileDemonCrystal || !world.m_46859_(vengefulPos)) {
                return;
            }
            tile = world.m_7702_(corrosivePos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getWillType() == EnumDemonWillType.CORROSIVE && ((TileDemonCrystal)tile).getCrystalCount() < 7) {
                corrosiveCrystals = ((TileDemonCrystal)tile).getCrystalCount();
            } else if (tile instanceof TileDemonCrystal || !world.m_46859_(corrosivePos)) {
                return;
            }
            tile = world.m_7702_(steadfastPos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getWillType() == EnumDemonWillType.STEADFAST && ((TileDemonCrystal)tile).getCrystalCount() < 7) {
                steadfastCrystals = ((TileDemonCrystal)tile).getCrystalCount();
            } else if (tile instanceof TileDemonCrystal || !world.m_46859_(steadfastPos)) {
                return;
            }
            tile = world.m_7702_(destructivePos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getWillType() == EnumDemonWillType.DESTRUCTIVE && ((TileDemonCrystal)tile).getCrystalCount() < 7) {
                destructiveCrystals = ((TileDemonCrystal)tile).getCrystalCount();
            } else if (tile instanceof TileDemonCrystal || !world.m_46859_(destructivePos)) {
                return;
            }
            rawTile.setCrystalCount(rawTile.getCrystalCount() - 4);
            this.growCrystal(world, vengefulPos, EnumDemonWillType.VENGEFUL, vengefulCrystals);
            this.growCrystal(world, corrosivePos, EnumDemonWillType.CORROSIVE, corrosiveCrystals);
            this.growCrystal(world, steadfastPos, EnumDemonWillType.STEADFAST, steadfastCrystals);
            this.growCrystal(world, destructivePos, EnumDemonWillType.DESTRUCTIVE, destructiveCrystals);
            rawTile.m_6596_();
            world.m_7260_(rawPos, rawState, rawState, 3);
        }
    }

    public Direction rotateFacing(Direction facing, Direction rotation) {
        switch (rotation) {
            case EAST: {
                return facing.m_122427_();
            }
            case SOUTH: {
                return facing.m_122427_().m_122427_();
            }
            case WEST: {
                return facing.m_122428_();
            }
        }
        return facing;
    }

    public void growCrystal(Level world, BlockPos pos, EnumDemonWillType type, int currentCrystalCount) {
        if (currentCrystalCount <= 0) {
            world.m_7731_(pos, switch (type) {
                case EnumDemonWillType.CORROSIVE -> ((Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get()).m_49966_();
                case EnumDemonWillType.DEFAULT -> ((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get()).m_49966_();
                case EnumDemonWillType.DESTRUCTIVE -> ((Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get()).m_49966_();
                case EnumDemonWillType.STEADFAST -> ((Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get()).m_49966_();
                case EnumDemonWillType.VENGEFUL -> ((Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get()).m_49966_();
                default -> ((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get()).m_49966_();
            }, 3);
        } else {
            TileDemonCrystal tile = (TileDemonCrystal)world.m_7702_(pos);
            tile.setCrystalCount(currentCrystalCount + 1);
            tile.m_6596_();
            BlockState state = world.m_8055_(pos);
            world.m_7260_(pos, state, state, 3);
        }
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 1000;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, 0, -1, EnumRuneType.FIRE);
        this.addRune(components, 1, 0, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 0, 1, EnumRuneType.WATER);
        this.addRune(components, -1, 0, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, -1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 1, 0, EnumRuneType.BLANK);
        this.addParallelRunes(components, 2, 0, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrystalSplit();
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{Component.m_237115_((String)(this.getTranslationKey() + ".info"))};
    }
}

