/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="yawning_void")
public class RitualYawningVoid
extends Ritual {
    public static final String PLACEMENT_RANGE = "placementRange";
    public static final String QUARRY_RANGE = "quarryRange";
    public static final String CHEST_RANGE = "chest";
    public static double rawWillDrain = 0.05;
    public static double steadfastWillDrain = 0.05;
    public static double corrosiveWillDrain = 0.05;
    public static int defaultRefreshTime = 10;
    public int refreshTime = 10;
    public BlockPos lastPos;

    public RitualYawningVoid() {
        super("ritualYawningVoid", 0, 5000, "ritual.bloodmagic.yawningVoidRitual");
        this.addBlockRange(PLACEMENT_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3));
        this.addBlockRange(QUARRY_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, -3, -1), 3));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(PLACEMENT_RANGE, 50, 4, 4);
        this.setMaximumVolumeAndDistanceOfRange(QUARRY_RANGE, 0, 64, 32);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        AreaDescriptor chestRange;
        BlockEntity tile;
        boolean consumeCorrosiveWill;
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        this.refreshTime = this.getRefreshTimeForRawWill(rawWill);
        boolean consumeRawWill = rawWill >= rawWillDrain && this.refreshTime != defaultRefreshTime;
        BlockPos replacement = pos;
        boolean replaceNonDestroyed = steadfastWill >= steadfastWillDrain;
        boolean destroy = !replaceNonDestroyed;
        boolean tryFilter = corrosiveWill >= corrosiveWillDrain;
        boolean consumeSteadfastWill = steadfastWill >= steadfastWillDrain;
        boolean bl = consumeCorrosiveWill = corrosiveWill >= corrosiveWillDrain;
        if (!consumeSteadfastWill && willConfig.contains((Object)EnumDemonWillType.STEADFAST) || !consumeCorrosiveWill && willConfig.contains((Object)EnumDemonWillType.CORROSIVE)) {
            return;
        }
        boolean replace = false;
        if (replaceNonDestroyed) {
            AreaDescriptor placementRange = masterRitualStone.getBlockRange(PLACEMENT_RANGE);
            for (BlockPos offset : placementRange.getContainedPositions(pos)) {
                if (!world.m_46859_(offset)) continue;
                replacement = offset;
                replace = true;
                break;
            }
        }
        BlockState downState = world.m_8055_(pos.m_7495_());
        int maxBlockChecks = 100;
        int checks = 0;
        AreaDescriptor.Rectangle quarryRange = (AreaDescriptor.Rectangle)masterRitualStone.getBlockRange(QUARRY_RANGE);
        BlockPos minOffset = quarryRange.getMinimumOffset();
        BlockPos maxOffset = quarryRange.getMaximumOffset().m_7918_(-1, -1, -1);
        boolean isDone = false;
        IItemHandler inventory = null;
        boolean doFilter = false;
        if (tryFilter && (tile = world.m_7702_((chestRange = masterRitualStone.getBlockRange(CHEST_RANGE)).getContainedPositions(pos).get(0))) != null && (inventory = Utils.getInventory(tile, null)) != null) {
            doFilter = true;
        }
        if (replace || destroy) {
            if (doFilter) {
                destroy = false;
            }
            int j = maxOffset.m_123342_();
            int i = minOffset.m_123341_();
            int k = minOffset.m_123343_();
            if (this.lastPos != null && !this.lastPos.equals((Object)BlockPos.f_121853_)) {
                j = this.lastPos.m_123342_();
                i = Math.min(maxOffset.m_123341_(), Math.max(i, this.lastPos.m_123341_()));
                k = Math.min(maxOffset.m_123343_(), Math.max(k, this.lastPos.m_123343_()));
            }
            while (j >= minOffset.m_123342_()) {
                while (i <= maxOffset.m_123341_()) {
                    while (k <= maxOffset.m_123343_()) {
                        if (checks >= maxBlockChecks || isDone) {
                            this.lastPos = new BlockPos(i, j, k);
                            return;
                        }
                        ++checks;
                        BlockPos newPos = pos.m_7918_(i, j, k);
                        BlockState state = world.m_8055_(newPos);
                        if (!state.m_60795_()) {
                            ItemStack checkStack = new ItemStack((ItemLike)state.m_60734_());
                            if (doFilter) {
                                for (int n = 0; n < inventory.getSlots(); ++n) {
                                    ItemStack filterStack = inventory.getStackInSlot(n);
                                    if (filterStack.m_41619_() || !(filterStack.m_41720_() instanceof IItemFilterProvider)) continue;
                                    IItemFilterProvider filterItem = (IItemFilterProvider)filterStack.m_41720_();
                                    IItemFilter filter = filterItem.getUninitializedItemFilter(filterStack);
                                    if (!filter.doesStackPassFilter(checkStack)) break;
                                    destroy = true;
                                    break;
                                }
                            }
                            if (destroy) {
                                world.m_7731_(newPos, Blocks.f_50016_.m_49966_(), 3);
                                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                                this.lastPos = new BlockPos(i, j, ++k);
                                isDone = true;
                                consumeSteadfastWill = false;
                                continue;
                            }
                            if (replace) {
                                Utils.swapLocations(world, newPos, world, replacement);
                                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                                this.lastPos = new BlockPos(i, j, ++k);
                                isDone = true;
                                continue;
                            }
                            ++k;
                            continue;
                        }
                        ++k;
                    }
                    ++i;
                    k = minOffset.m_123343_();
                }
                --j;
                i = minOffset.m_123341_();
            }
            j = maxOffset.m_123342_();
            this.lastPos = new BlockPos(i, j, k);
        }
        if (isDone) {
            if (consumeRawWill) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawWillDrain, true);
            }
            if (consumeCorrosiveWill) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveWillDrain, true);
            }
            if (consumeSteadfastWill) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastWillDrain, true);
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.lastPos = new BlockPos(tag.m_128451_("xCoord"), tag.m_128451_("yCoord"), tag.m_128451_("zCoord"));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.lastPos != null) {
            tag.m_128405_("xCoord", this.lastPos.m_123341_());
            tag.m_128405_("yCoord", this.lastPos.m_123342_());
            tag.m_128405_("zCoord", this.lastPos.m_123343_());
        }
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{Component.m_237115_((String)(this.getTranslationKey() + ".info")), Component.m_237115_((String)(this.getTranslationKey() + ".default.info")), Component.m_237115_((String)(this.getTranslationKey() + ".corrosive.info")), Component.m_237115_((String)(this.getTranslationKey() + ".steadfast.info"))};
    }

    public int getRefreshTimeForRawWill(double rawWill) {
        if (rawWill >= rawWillDrain) {
            return Math.max(1, (int)(10.0 - rawWill / 10.0));
        }
        return defaultRefreshTime;
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.BLANK);
        this.addParallelRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 1, 3, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 3, 1, 0, EnumRuneType.WATER);
        this.addCornerRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 3, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 1, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 2, EnumRuneType.EARTH);
        this.addParallelRunes(components, 3, 3, EnumRuneType.AIR);
        this.addCornerRunes(components, 2, 3, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 2, 1, 3, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, 3, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualYawningVoid();
    }
}

