/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.ic2;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerTile;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

record PowerTileEnergySink(PowerTile tile) implements IEnergySink
{
    public Level getWorldObj() {
        return this.tile.m_58904_();
    }

    public BlockPos getPosition() {
        return this.tile.m_58899_();
    }

    public int getSinkTier() {
        return 6;
    }

    public int getRequestedEnergy() {
        long canAcceptNanoFE = this.tile.getMaxEnergy() - this.tile.getEnergy();
        long canAcceptEU = canAcceptNanoFE / (Long)QuarryPlus.config.powerMap.ic2ConversionRate.get();
        return (int)Mth.m_14036_((float)0.0f, (float)canAcceptEU, (float)2.1474836E9f);
    }

    public int acceptEnergy(Direction direction, int amount, int voltage) {
        if (this.tile.getMaxEnergy() - this.tile.getEnergy() == 0L) {
            return 0;
        }
        long energyNanoFE = (long)amount * (Long)QuarryPlus.config.powerMap.ic2ConversionRate.get();
        long acceptedNanoFE = this.tile.addEnergy(energyNanoFE, false);
        long acceptedEU = acceptedNanoFE / (Long)QuarryPlus.config.powerMap.ic2ConversionRate.get();
        return amount - (int)acceptedEU;
    }

    public boolean canAcceptEnergy(IEnergyEmitter emitter, Direction side) {
        return true;
    }
}

