/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.jetbrains.annotations.Nullable;

public class QPBlock
extends Block {
    public static final BooleanProperty WORKING = BooleanProperty.m_61465_((String)"working");
    private final ResourceLocation registryName;
    public final QPBlockItem blockItem;

    public QPBlock(BlockBehaviour.Properties properties, String name, Function<QPBlock, QPBlockItem> itemFunction) {
        super(properties);
        this.registryName = new ResourceLocation("quarryplus", name);
        this.blockItem = itemFunction.apply(this);
    }

    public QPBlock(BlockBehaviour.Properties properties, String name) {
        this(properties, name, b -> new QPBlockItem((QPBlock)((Object)b), new Item.Properties()));
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public final Item m_5456_() {
        return this.blockItem;
    }

    public void m_6402_(Level level, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(level, pPos, pState, pPlacer, pStack);
        if (!level.f_46443_ && this.disallowedDim().contains(level.m_46472_().m_135782_()) && pPlacer instanceof Player) {
            Player player = (Player)pPlacer;
            player.m_5661_((Component)Component.m_237113_((String)"This block doesn't work in this dimension by server config"), false);
        }
    }

    public Set<ResourceLocation> disallowedDim() {
        return ((List)QuarryPlus.serverConfig.machineWork.unworkableDimensions.get()).stream().map(ResourceLocation::m_135820_).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> type1, BlockEntityType<E> exceptedType, CombinedBlockEntityTicker<? super E> ticker) {
        return exceptedType == type1 ? ticker : null;
    }

    public static class QPBlockItem
    extends BlockItem {
        public QPBlockItem(QPBlock block, Item.Properties properties) {
            super((Block)block, properties);
        }

        public String toString() {
            return this.getRegistryName().m_135815_();
        }

        public ResourceLocation getRegistryName() {
            return ((QPBlock)this.m_40614_()).getRegistryName();
        }

        public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
            super.m_7373_(pStack, pLevel, tooltips, pIsAdvanced);
            if (QuarryPlus.config != null && !QuarryPlus.config.enableMap.enabled(this.getRegistryName())) {
                tooltips.add((Component)Component.m_237115_((String)"quarryplus.tooltip.item_disable_message"));
            }
        }

        public List<ItemStack> creativeTabItem() {
            return List.of(new ItemStack((ItemLike)this));
        }
    }
}

