/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.miningwell;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.miningwell.MiningWellItem;
import com.yogpc.qp.machines.miningwell.MiningWellTile;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class MiningWellBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "mining_well";

    public MiningWellBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_278166_(PushReaction.BLOCK).m_60978_(1.5f), NAME, MiningWellItem::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WORKING, BlockStateProperties.f_61372_});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Holder.MINING_WELL_TYPE.m_155264_(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_43723_() == null ? Direction.NORTH : ctx.m_43723_().m_6350_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof MiningWellTile) {
            MiningWellTile miningWellTile = (MiningWellTile)blockEntity;
            int efficiencyLevel = stack.getEnchantmentLevel(Enchantments.f_44984_);
            miningWellTile.setEfficiencyLevel(efficiencyLevel);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (state.m_60734_() != oldState.m_60734_() && !level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof MiningWellTile) {
            MiningWellTile miningWellTile = (MiningWellTile)blockEntity;
            miningWellTile.digMinY = level.m_141937_();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!world.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (WrenchItems.isWrenchItem(stack)) {
            if (!world.f_46443_) {
                world.m_141902_(pos, Holder.MINING_WELL_TYPE).ifPresent(MiningWellTile::reset);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof MiningWellTile) {
            MiningWellTile miningWellTile = (MiningWellTile)blockEntity;
            EnchantedLootFunction.process(stack, miningWellTile);
        }
        return stack;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : MiningWellBlock.checkType(blockEntityType, Holder.MINING_WELL_TYPE, CombinedBlockEntityTicker.of(this, level, PowerTile.getGenerator(), (l, p, s, t) -> t.tick(), PowerTile.logTicker(), MachineStorage.passItems(), MachineStorage.passFluid()));
    }
}

