/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mover;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.EnchantableItem;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.mover.SlotMover;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ContainerMover
extends AbstractContainerMenu {
    final Container craftMatrix = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            ContainerMover.this.updateEnchantmentList();
        }
    };
    private final Level worldObj;
    List<Enchantment> movable = Collections.emptyList();
    @Nullable
    Enchantment selected = null;
    final BlockPos pos;

    public ContainerMover(int id, Player player, BlockPos pos) {
        super(Holder.MOVER_MENU_TYPE, id);
        int col;
        Inventory inv = player.m_150109_();
        this.worldObj = player.m_9236_();
        this.pos = pos;
        for (col = 0; col < 2; ++col) {
            this.m_38897_(new SlotMover(this.craftMatrix, col, 8 + col * 144, 40));
        }
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 104 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 162));
        }
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (!this.worldObj.f_46443_) {
            IntStream.range(0, this.craftMatrix.m_6643_()).mapToObj(arg_0 -> ((Container)this.craftMatrix).m_8016_(arg_0)).filter(Predicate.not(ItemStack::m_41619_)).forEach(arg_0 -> ((Inventory)playerIn.m_150109_()).m_150079_(arg_0));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.worldObj.m_8055_(this.pos).m_60713_((Block)Holder.BLOCK_MOVER) && playerIn.m_20238_(Vec3.m_82512_((Vec3i)this.pos)) <= 64.0;
    }

    void updateEnchantmentList() {
        ItemStack from = this.craftMatrix.m_8020_(0);
        ItemStack to = this.craftMatrix.m_8020_(1);
        if (from.m_41619_() || to.m_41619_() || from.m_41785_().isEmpty() || !(to.m_41720_() instanceof EnchantableItem)) {
            this.movable = Collections.emptyList();
            this.selected = null;
        } else {
            List<Enchantment> newMovable = ContainerMover.getMovable(from, to, (EnchantableItem)to.m_41720_());
            if (newMovable.isEmpty()) {
                this.selected = null;
            } else if (!newMovable.contains(this.selected)) {
                this.selected = newMovable.get(0);
            }
            this.movable = newMovable;
        }
    }

    @VisibleForTesting
    static List<Enchantment> getMovable(ItemStack from, ItemStack to, Predicate<Enchantment> predicate) {
        Map given = EnchantmentHelper.m_44831_((ItemStack)to);
        return EnchantmentLevel.fromItem(from).stream().map(EnchantmentLevel::enchantment).filter(e -> ContainerMover.canMoveEnchantment(predicate, given, e)).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    static boolean canMoveEnchantment(@Nullable Predicate<Enchantment> predicate, Map<Enchantment, Integer> given, Enchantment toMove) {
        if (predicate != null) {
            if (!predicate.test(toMove)) return false;
        }
        if (given.getOrDefault(toMove, 0) >= toMove.m_6586_()) return false;
        if (!given.keySet().stream().filter(Predicate.isEqual(toMove).negate()).allMatch(arg_0 -> ((Enchantment)toMove).m_44695_(arg_0))) return false;
        return true;
    }

    public Optional<Enchantment> getEnchantment() {
        return Optional.ofNullable(this.selected);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack src = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack remain = slot.m_7993_();
            src = remain.m_41777_();
            if (index < 2) {
                if (!this.m_38903_(remain, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                ItemStack put = ItemHandlerHelper.copyStackWithSize((ItemStack)remain, (int)1);
                boolean changed = false;
                Slot toSlot = this.m_38853_(0);
                if (toSlot.m_5857_(remain) && toSlot.m_7993_().m_41619_()) {
                    toSlot.m_5852_(put);
                    remain.m_41774_(1);
                    changed = true;
                }
                toSlot = this.m_38853_(1);
                if (!changed && toSlot.m_5857_(remain) && toSlot.m_7993_().m_41619_()) {
                    toSlot.m_5852_(put);
                    remain.m_41774_(1);
                    changed = true;
                }
                if (!changed) {
                    return ItemStack.f_41583_;
                }
            }
            if (remain.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (remain.m_41613_() == src.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, remain);
        }
        return src;
    }

    public void moveEnchant(Enchantment enchantment) {
        ItemStack from = this.craftMatrix.m_8020_(0);
        ItemStack to = this.craftMatrix.m_8020_(1);
        ContainerMover.moveEnchantment(enchantment, from, to, this::updateEnchantmentList);
    }

    static void moveEnchantment(@Nullable Enchantment enchantment, ItemStack from, ItemStack to, Runnable after) {
        EnchantableItem item;
        Item item2 = to.m_41720_();
        ContainerMover.moveEnchantment(enchantment, from, to, item2 instanceof EnchantableItem ? (item = (EnchantableItem)item2) : null, after);
    }

    @VisibleForTesting
    static void moveEnchantment(@Nullable Enchantment enchantment, ItemStack from, ItemStack to, @Nullable Predicate<Enchantment> predicate, Runnable after) {
        if (enchantment == null || from.m_41619_() || to.m_41619_()) {
            return;
        }
        if (ContainerMover.canMoveEnchantment(predicate, EnchantmentHelper.m_44831_((ItemStack)to), enchantment)) {
            ContainerMover.upLevel(enchantment, to);
            ContainerMover.downLevel(enchantment, from);
            after.run();
        }
    }

    @VisibleForTesting
    static void downLevel(Enchantment enchantment, ItemStack stack) {
        ListTag list = stack.m_41785_();
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbt = list.m_128728_(i);
                if (ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)nbt)) != enchantment) continue;
                int l = EnchantmentHelper.m_182438_((CompoundTag)nbt);
                if (l == 1) {
                    list.remove(i);
                    break;
                }
                EnchantmentHelper.m_182440_((CompoundTag)nbt, (int)(l - 1));
                break;
            }
            if (list.isEmpty()) {
                stack.m_41749_("Enchantments");
            }
        }
    }

    @VisibleForTesting
    static void upLevel(Enchantment enchantment, ItemStack stack) {
        int level = stack.getEnchantmentLevel(enchantment);
        if (level == 0) {
            stack.m_41663_(enchantment, 1);
        } else {
            ListTag list = stack.m_41785_();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbt = list.m_128728_(i);
                if (ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)nbt)) != enchantment) continue;
                EnchantmentHelper.m_182440_((CompoundTag)nbt, (int)(level + 1));
                break;
            }
        }
    }
}

