/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.registration;

import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.deferred.BlockDeferredRegister;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.world.block.BuddingCrystalBlock;
import slimeknights.tconstruct.world.block.CrystalBlock;
import slimeknights.tconstruct.world.block.CrystalClusterBlock;

public class GeodeItemObject
extends ItemObject<Item> {
    private final Supplier<? extends Block> block;
    private final Supplier<? extends Block> budding;
    private final Supplier<? extends Block> cluster;
    private final Supplier<? extends Block> smallBud;
    private final Supplier<? extends Block> mediumBud;
    private final Supplier<? extends Block> largeBud;

    public GeodeItemObject(RegistryObject<? extends Item> shard, BlockDeferredRegister register, MapColor color, SoundType blockSound, SoundEvent chimeSound, Map<BudSize, SoundType> clusterSounds, int baseLight, Item.Properties props) {
        super(shard);
        IntFunction<ToIntFunction> light = extra -> {
            int calculated = Math.min(extra + baseLight, 15);
            return state -> calculated;
        };
        String name = shard.getId().m_135815_();
        Function<Block, BlockItem> blockItem = block -> new BlockItem(block, props);
        ToIntFunction crystalLight = light.apply(0);
        this.block = register.register(name + "_block", () -> new CrystalBlock(chimeSound, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60953_(crystalLight).m_60978_(1.5f).m_60918_(blockSound).m_60999_()), blockItem);
        this.budding = register.register("budding_" + name, () -> new BuddingCrystalBlock(this, chimeSound, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60977_().m_60953_(crystalLight).m_60978_(1.5f).m_60918_(blockSound).m_60999_().m_278166_(PushReaction.DESTROY)), blockItem);
        Supplier<BlockBehaviour.Properties> budProps = () -> BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280606_().m_60955_().m_60977_().m_60978_(1.5f).m_60999_().m_278166_(PushReaction.DESTROY);
        this.cluster = register.register(name + "_cluster", () -> new CrystalClusterBlock(chimeSound, 7, 3, ((BlockBehaviour.Properties)budProps.get()).m_60953_((ToIntFunction)light.apply(5)).m_60918_((SoundType)clusterSounds.get((Object)BudSize.CLUSTER))), blockItem);
        this.smallBud = register.register("small_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 3, 3, ((BlockBehaviour.Properties)budProps.get()).m_60953_((ToIntFunction)light.apply(1)).m_60918_((SoundType)clusterSounds.get((Object)BudSize.SMALL))), blockItem);
        this.mediumBud = register.register("medium_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 4, 3, ((BlockBehaviour.Properties)budProps.get()).m_60953_((ToIntFunction)light.apply(2)).m_60918_((SoundType)clusterSounds.get((Object)BudSize.MEDIUM))), blockItem);
        this.largeBud = register.register("large_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 5, 3, ((BlockBehaviour.Properties)budProps.get()).m_60953_((ToIntFunction)light.apply(4)).m_60918_((SoundType)clusterSounds.get((Object)BudSize.LARGE))), blockItem);
    }

    public Block getBlock() {
        return this.block.get();
    }

    public Block getBudding() {
        return this.budding.get();
    }

    public Block getBud(BudSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case BudSize.SMALL -> this.smallBud.get();
            case BudSize.MEDIUM -> this.mediumBud.get();
            case BudSize.LARGE -> this.largeBud.get();
            case BudSize.CLUSTER -> this.cluster.get();
        };
    }

    public static enum BudSize {
        SMALL,
        MEDIUM,
        LARGE,
        CLUSTER;

        public static final BudSize[] SIZES;
        private final String name = this.name().toLowerCase(Locale.ROOT);
        private final int size = this.ordinal() + 1;

        public BudSize getNext() {
            return switch (this) {
                case SMALL -> MEDIUM;
                case MEDIUM -> LARGE;
                case LARGE -> CLUSTER;
                default -> SMALL;
            };
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }

        static {
            SIZES = new BudSize[]{SMALL, MEDIUM, LARGE};
        }
    }
}

