/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantIdImpl;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.IdParser;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MaterialVariantId {
    public static final Loadable<MaterialVariantId> LOADABLE = StringLoadable.DEFAULT.comapFlatMap((text, error) -> {
        MaterialVariantId location = MaterialVariantId.tryParse(text);
        if (location == null) {
            throw error.create("Expected a material variant ID, was '" + text + "'");
        }
        return location;
    }, Object::toString);
    public static final ContextKey<MaterialVariantId> CONTEXT_KEY = new ContextKey("material_variant");
    public static final String DEFAULT_VARIANT = "default";

    public MaterialId getId();

    public String getVariant();

    public boolean hasVariant();

    public ResourceLocation getLocation(char var1);

    public String getSuffix();

    public boolean matchesVariant(MaterialVariantId var1);

    default public boolean matchesVariant(MaterialVariant other) {
        return this.matchesVariant(other.getVariant());
    }

    default public boolean matchesVariant(ItemStack stack) {
        return this.matchesVariant(IMaterialItem.getMaterialFromStack(stack));
    }

    default public boolean sameVariant(MaterialVariantId other) {
        return this.getId().equals(other.getId()) && this.getVariant().equals(other.getVariant());
    }

    public static MaterialVariantId create(String domain, String path, String variant) {
        return MaterialVariantId.create(new MaterialId(domain, path), variant);
    }

    public static MaterialVariantId create(MaterialId id, String variant) {
        if (variant.isEmpty()) {
            return id;
        }
        if (!ResourceLocation.m_135841_((String)variant)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in variant of material variant ID: " + id + "#" + variant);
        }
        return new MaterialVariantIdImpl(id, variant);
    }

    @Nullable
    public static MaterialVariantId tryParse(String defaultDomain, String string) {
        String[] parts;
        MaterialId materialId;
        int index = string.indexOf(35);
        String variant = "";
        if (index >= 0) {
            variant = string.substring(index + 1);
            if (!ResourceLocation.m_135841_((String)variant)) {
                return null;
            }
            string = string.substring(0, index);
        }
        if ((materialId = MaterialId.tryBuild((parts = IdParser.decompose(defaultDomain, string))[0], parts[1])) == null) {
            return null;
        }
        return MaterialVariantId.create(materialId, variant);
    }

    @Nullable
    public static MaterialVariantId tryParse(String string) {
        return MaterialVariantId.tryParse("minecraft", string);
    }

    private static boolean isAllowed(char ch) {
        return ch == '#' || ResourceLocation.m_135816_((char)ch);
    }

    @Nullable
    public static MaterialVariantId read(String defaultDomain, StringReader reader) {
        int start = reader.getCursor();
        while (reader.canRead() && MaterialVariantId.isAllowed(reader.peek())) {
            reader.skip();
        }
        String substring = reader.getString().substring(start, reader.getCursor());
        MaterialVariantId variant = MaterialVariantId.tryParse(defaultDomain, substring);
        if (variant == null) {
            reader.setCursor(start);
            return null;
        }
        return variant;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static MaterialVariantId tryParse(StringReader reader) {
        return MaterialVariantId.read("minecraft", reader);
    }

    public static MaterialVariantId parse(String text) {
        MaterialVariantId location = MaterialVariantId.tryParse(text);
        if (location == null) {
            throw new JsonSyntaxException("Expected a material variant ID, was '" + text + "'");
        }
        return location;
    }

    private static MaterialVariantId parse(String text, String key) {
        MaterialVariantId location = MaterialVariantId.tryParse(text);
        if (location == null) {
            throw new JsonSyntaxException("Expected " + key + " to be a material variant ID, was '" + text + "'");
        }
        return location;
    }

    public static MaterialVariantId fromJson(JsonObject json, String key) {
        String text = GsonHelper.m_13906_((JsonObject)json, (String)key);
        return MaterialVariantId.parse(text, key);
    }

    public static MaterialVariantId convertJson(JsonElement json, String key) {
        String text = GsonHelper.m_13805_((JsonElement)json, (String)key);
        return MaterialVariantId.parse(text, key);
    }

    default public void toNetwork(FriendlyByteBuf buf) {
        buf.m_130070_(this.toString());
    }

    public static MaterialVariantId fromNetwork(FriendlyByteBuf buf) {
        return MaterialVariantId.parse(buf.m_130136_(Short.MAX_VALUE));
    }
}

