/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public enum BlockInteractFluidEffect implements FluidEffect<FluidEffectContext.Block>
{
    INSTANCE;

    private final SingletonLoader<BlockInteractFluidEffect> loader = new SingletonLoader((Object)this);

    private static void damageIfNeeded(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        if (!level.f_46443_ && context.m_43723_() == null && stack.m_41763_() && !stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            stack.m_220157_(1, level.m_213780_(), null);
            if (stack.m_41773_() >= stack.m_41776_()) {
                stack.m_41774_(1);
                stack.m_41721_(0);
                level.m_5594_(null, context.m_8083_(), SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Block context, IFluidHandler.FluidAction action) {
        InteractionHand[] interactionHandArray;
        Level world = context.getLevel();
        BlockPos pos = context.getBlockPos();
        if (!world.m_6857_().m_61937_(pos)) {
            return 0.0f;
        }
        BlockState state = context.getBlockState();
        FeatureFlagSet enabled = world.m_246046_();
        if (!state.m_60734_().m_245993_(enabled)) {
            return 0.0f;
        }
        if (action.simulate()) {
            return 1.0f;
        }
        LivingEntity entity = context.getEntity();
        Player player = context.getPlayer();
        boolean skipBlock = false;
        if (player != null) {
            skipBlock = player.m_36341_() && !player.m_21205_().doesSneakBypassUse((LevelReader)world, pos, player) || !player.m_21206_().doesSneakBypassUse((LevelReader)player.m_9236_(), pos, player);
        } else if (entity != null) {
            skipBlock = entity.m_6144_() && !entity.m_21205_().m_41619_() || !entity.m_21206_().m_41619_();
        }
        BlockHitResult hitResult = context.getHitResult();
        if (entity == null) {
            InteractionHand[] interactionHandArray2 = new InteractionHand[1];
            interactionHandArray = interactionHandArray2;
            interactionHandArray2[0] = InteractionHand.MAIN_HAND;
        } else {
            interactionHandArray = InteractionHand.values();
        }
        for (InteractionHand hand : interactionHandArray) {
            InteractionResult result;
            InteractionResult result2;
            ItemStack heldItem = context.getStack();
            if (entity != null) {
                heldItem = entity.m_21120_(hand);
            }
            if (!heldItem.m_246617_(enabled)) {
                return 0.0f;
            }
            Event.Result useItem = Event.Result.DEFAULT;
            Event.Result useBlock = Event.Result.DEFAULT;
            if (player != null) {
                PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)player, (InteractionHand)hand, (BlockPos)pos, (BlockHitResult)hitResult);
                if (event.isCanceled()) {
                    if (event.getCancellationResult().m_19077_()) {
                        if (entity != null) {
                            entity.m_21011_(hand, true);
                        }
                        return 1.0f;
                    }
                    return 0.0f;
                }
                useItem = event.getUseItem();
                useBlock = event.getUseBlock();
            }
            UseOnContext useContext = new UseOnContext(world, player, hand, heldItem, hitResult);
            if (useItem != Event.Result.DENY && !heldItem.m_41619_() && (result2 = heldItem.onItemUseFirst(useContext)) != InteractionResult.PASS) {
                if (result2.m_19077_()) {
                    if (entity != null) {
                        entity.m_21011_(hand, true);
                    }
                    BlockInteractFluidEffect.damageIfNeeded(useContext);
                    return 1.0f;
                }
                return 0.0f;
            }
            ItemStack original = heldItem.m_41777_();
            if (player != null && (useBlock == Event.Result.ALLOW || useItem == Event.Result.DEFAULT && !skipBlock) && (result = state.m_60664_(world, player, hand, hitResult)).m_19077_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, original);
                }
                player.m_21011_(hand, true);
                return 1.0f;
            }
            if (useItem != Event.Result.ALLOW && (useItem != Event.Result.DEFAULT || heldItem.m_41619_() || player != null && player.m_36335_().m_41519_(heldItem.m_41720_()))) continue;
            if (player != null && player.m_7500_()) {
                int oldCount = heldItem.m_41613_();
                result = heldItem.m_41661_(useContext);
                heldItem.m_41764_(oldCount);
            } else {
                result = heldItem.m_41661_(useContext);
                BlockInteractFluidEffect.damageIfNeeded(useContext);
            }
            if (result == InteractionResult.PASS) continue;
            if (result.m_19077_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, heldItem);
                }
                if (entity != null) {
                    entity.m_21011_(hand, true);
                }
                return 1.0f;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return Component.m_237115_((String)(FluidEffect.getTranslationKey(this.getLoader()) + ".block"));
    }

    public SingletonLoader<BlockInteractFluidEffect> getLoader() {
        return this.loader;
    }
}

